<?php

/**
 * Template part for displaying Page Header
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package roofsie
 */
?>

<!--Page Header Start-->
<section class="page-header">
	<div class="page-header-bg"></div>
	<div class="container">
		<div class="page-header__inner">
			<?php $roofsie_page_meta_breadcumb_status = empty(get_post_meta(get_the_ID(), 'roofsie_show_page_breadcrumb', true)) ? 'on' : get_post_meta(get_the_ID(), 'roofsie_show_page_breadcrumb', true); ?>
			<?php if (function_exists('bcn_display') && 'yes' == get_theme_mod('breadcrumb_opt', 'off') && 'on' == $roofsie_page_meta_breadcumb_status) : ?>
				<ul class="thm-breadcrumb list-unstyled ml-0" typeof="BreadcrumbList" vocab="https://schema.org/">
					<?php bcn_display_list(); ?>
				</ul>
			<?php endif; ?>

			<?php
			$roofsie_page_title_text = !empty(get_post_meta(get_the_ID(), 'roofsie_set_header_title', true)) ? get_post_meta(get_the_ID(), 'roofsie_set_header_title', true) : get_the_title();
			$roofsie_page_header_tag = apply_filters('roofsie_page_header_tag', 'h2');
			?>
			<<?php echo esc_attr($roofsie_page_header_tag); ?>>
				<?php if (!is_page()) : ?>
					<?php roofsie_page_title(); ?>
				<?php else : ?>
					<?php echo wp_kses($roofsie_page_title_text, 'roofsie_allowed_tags') ?>
				<?php endif; ?>
			</<?php echo esc_attr($roofsie_page_header_tag); ?>>
		</div>
	</div>
</section>
<!--Page Header End-->