<?php

/**
 * Template part for displaying footer
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package roofsie
 */
?>


<?php
$roofsie_page_id     = get_queried_object_id();
$roofsie_custom_footer_status = !empty(get_post_meta($roofsie_page_id, 'roofsie_custom_footer_status', true)) ? get_post_meta($roofsie_page_id, 'roofsie_custom_footer_status', true) : 'off';

$roofsie_custom_footer_id = '';
if ((is_page() && 'on' === $roofsie_custom_footer_status) || (is_singular('portfolio') && 'on' === $roofsie_custom_footer_status) || (is_singular('service') && 'on' === $roofsie_custom_footer_status)) {
	$roofsie_custom_footer_id = get_post_meta($roofsie_page_id, 'roofsie_select_custom_footer', true);
} elseif ('yes' == get_theme_mod('footer_custom')) {
	$roofsie_custom_footer_id = get_theme_mod('footer_custom_post');
} else {
	$roofsie_custom_footer_id = 'default_footer';
}

$roofsie_dynamic_footer = isset($_GET['custom_footer_id']) ? $_GET['custom_footer_id'] : $roofsie_custom_footer_id;
?>


<?php if ('default_footer' == $roofsie_dynamic_footer) : ?>
	<div class="site-footer">
		<div class="site-footer__bottom">
			<div class="row">
				<div class="col-xl-12">
					<div class="site-footer__bottom-inner">
						<p class="site-footer__bottom-text"><?php echo wp_kses(get_theme_mod('footer_copytext', esc_html__('&copy; Copyright 2022 by Roofsie', 'roofsie')), 'roofsie_allowed_tags'); ?></p>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php else : ?>
	<?php echo do_shortcode('[roofsie-footer id="' . $roofsie_dynamic_footer . '"]');
	?>
<?php endif; ?>