<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package roofsie
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php roofsie_post_thumbnail(); ?>

	<div class="clearfix blog-details__content">
		<header class="entry-header">
			<?php
			if ('post' === get_post_type()) :
			?>
				<ul class="list-unstyled blog-sidebar__meta ml-0">
					<li><?php roofsie_posted_on(); ?></li>
					<li><?php roofsie_posted_by(); ?></li>
				</ul>
			<?php endif; ?>
		</header><!-- .entry-header -->
		<?php
		the_content(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					esc_html__('Continue reading', 'roofsie') . '<span class="screen-reader-text"> "%s"</span>',
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				wp_kses_post(get_the_title())
			)
		);

		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__('Pages:', 'roofsie'),
				'after'  => '</div>',
			)
		);
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer blog-details__bottom">
		<?php roofsie_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-<?php the_ID(); ?> -->