<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package roofsie
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('blog-sidebar__content'); ?>>

	<!--Blog Sidebar Single Start-->
	<div class="blog-sidebar__single">

		<?php roofsie_post_thumbnail(); ?>

		<div class="blog-sidebar__content-box">
			<ul class="list-unstyled blog-sidebar__meta ml-0">
				<li><?php roofsie_posted_on(); ?></li>
				<li><?php roofsie_posted_by(); ?></li>
			</ul>
			<h3 class="blog-sidebar__title">
				<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
			</h3>
			<?php $roofsie_excerpt_count = apply_filters('roofsie_excerpt_count', 41); ?>
			<p class="blog-sidebar__text"><?php roofsie_excerpt($roofsie_excerpt_count); ?></p>
			<div class="blog-sidebar__bottom-btn-box">
				<a href="<?php the_permalink(); ?>" class="blog-sidebar__btn thm-btn"> <i class="fa fa-arrow-right"></i> <?php esc_html_e('Read More', 'roofsie'); ?></a>
			</div>
		</div>
	</div>
	<!--Blog Sidebar Single End-->

</article><!-- #post-<?php the_ID(); ?> -->