<?php

/**
 * roofsie functions for getting inline styles from theme customizer
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package roofsie
 */

if (!function_exists('roofsie_theme_customizer_styles')) :
	function roofsie_theme_customizer_styles()
	{

		// roofsie color option

		$roofsie_inline_style = '';
		$roofsie_inline_style .= ':root {
			  --roofsie-primary: ' . get_theme_mod('theme_primary_color', sanitize_hex_color('#f4f1ee')) . ';
			  --roofsie-primary-rgb: ' . roofsie_hex_to_rgb(get_theme_mod('theme_primary_color', sanitize_hex_color('#f4f1ee'))) . ';
			  --roofsie-base: ' . get_theme_mod('theme_base_color', sanitize_hex_color('#ff4f47')) . ';
			  --roofsie-base-rgb: ' . roofsie_hex_to_rgb(get_theme_mod('theme_base_color', sanitize_hex_color('#ff4f47'))) . ';

			}';

		$roofsie_inner_banner_bg = get_theme_mod('page_header_bg_image');
		$roofsie_inline_style .= '.page-header-bg { background-image: url(' . $roofsie_inner_banner_bg . '); } ';

		$roofsie_preloader_icon = get_theme_mod('preloader_image');
		if ($roofsie_preloader_icon) {
			$roofsie_inline_style .= '.preloader .preloader__image { background-image: url(' . $roofsie_preloader_icon . '); } ';
		}

		if (is_page()) {


			$roofsie_page_base_color = empty(get_post_meta(get_the_ID(), 'theme_primary_color', true)) ? get_theme_mod('theme_primary_color', sanitize_hex_color('#f4f1ee')) : get_post_meta(get_the_ID(), 'theme_primary_color', true);

			$roofsie_page_black_color = empty(get_post_meta(get_the_ID(), 'theme_base_color', true)) ? get_theme_mod('theme_base_color', sanitize_hex_color('#ff4f47')) : get_post_meta(get_the_ID(), 'theme_base_color', true);

			$roofsie_inline_style .= ':root {
				--roofsie-primary: ' . $roofsie_page_base_color . ';
				--roofsie-primary-rgb: ' . roofsie_hex_to_rgb($roofsie_page_base_color) . ';
				--roofsie-base: ' . $roofsie_page_black_color . ';
				--roofsie-base-rgb: ' . roofsie_hex_to_rgb($roofsie_page_black_color) . ';

				}';

			$roofsie_page_header_bg = empty(get_post_meta(get_the_ID(), 'roofsie_set_header_image', true)) ? get_theme_mod('page_header_bg_image') : get_post_meta(get_the_ID(), 'roofsie_set_header_image', true);

			$roofsie_inline_style .= '.page-header-bg { background-image: url(' . $roofsie_page_header_bg . '); }';
		}


		wp_add_inline_style('roofsie-style', $roofsie_inline_style);
	}
endif;

add_action('wp_enqueue_scripts', 'roofsie_theme_customizer_styles');
