<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package roofsie
 */

get_header();
?>

<main id="primary" class="site-main">

	<!--Error Page Start-->
	<section class="error-page">
		<div class="container">
			<div class="row">
				<div class="col-xl-12">
					<div class="error-page__inner">
						<div class="error-page__title-box">
							<h2 class="error-page__title"><?php esc_html_e('404', 'roofsie'); ?></h2>
							<h2 class="error-page__title-2"><?php esc_html_e('404', 'roofsie'); ?></h2>
						</div>
						<h3 class="error-page__tagline"><?php echo esc_html__('Sorry we can\'t find that page!', 'roofsie'); ?></h3>
						<p class="error-page__text"><?php echo esc_html__('The page you are looking for was never existed.', 'roofsie'); ?></p>
						<form class="error-page__form" method="get" action="<?php echo esc_url(home_url()); ?>">
							<div class="error-page__form-input">
								<input type="search" name="s" placeholder="<?php echo esc_attr('Search here', 'roofsie'); ?>">
								<button type="submit"><i class="icon-magnifying-glass"></i></button>
							</div>
						</form>
						<a href="<?php echo esc_url(home_url('/')); ?>" class="thm-btn error-page__btn"><i class="fa fa-arrow-right"></i> <?php echo esc_html_e('Back to home', 'roofsie'); ?></a>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--Error Page End-->

</main><!-- #main -->

<?php
get_footer();
