<?php
get_header(); ?>

<section class="service-details">
    <div class="container">
        <div class="row">
            <div class="col-xl-4 col-lg-5">
                <div class="service-details__sidebar">
                    <div class="service-details__sidebar-service">
                        <?php if (!empty(get_theme_mod('roofsie_sidebar_menu_item'))) : ?>
                            <?php wp_nav_menu(array(
                                'menu' => get_theme_mod('roofsie_sidebar_menu_item'),
                                'menu_class' => 'service-details__sidebar-service-list list-unstyled ml-0',
                                'link_before'      => '<span class="icon-right-arrow"></span>'
                            )); ?>
                        <?php endif; ?>
                    </div>
                    <div class="service-details__need-help">
                        <?php if (!empty(get_theme_mod('roofsie_contact_sidebar_image'))) : ?>
                            <div class="service-details__need-help-bg" style="background-image: url(<?php echo esc_url(get_theme_mod('roofsie_contact_sidebar_image')); ?>)">
                            </div>
                        <?php endif; ?>
                        <div class="service-details__need-help-icon">
                            <span class="<?php echo esc_attr(get_theme_mod('roofsie_sidebar_icon', 'icon-chatting')); ?>"></span>
                        </div>
                        <h2 class="service-details__need-help-title"><?php echo wp_kses(get_theme_mod('roofsie_sidebar_contact_title', __('Best Quality <br> services', 'roofsie')), 'roofsie_allowed_tags'); ?></h2>
                        <div class="service-details__need-help-contact">
                            <p><?php echo wp_kses(get_theme_mod('roofsie_sidebar_contact_text', __('Call us Anytime', 'roofsie')), 'roofsie_allowed_tags'); ?></p>
                            <a href="<?php echo esc_url(get_theme_mod('roofsie_sidebar_contact_number_link', __('#', 'roofsie'))); ?>"><?php echo esc_html(get_theme_mod('roofsie_sidebar_contact_number', __('666 888 000', 'roofsie'))); ?></a>
                        </div>
                    </div>
                    <div class="service-details__download">
                        <a href="<?php echo esc_url(get_theme_mod('roofsie_sidebar_download_url', __('#', 'roofsie'))); ?>" class="service-details__download-btn"><?php echo wp_kses(get_theme_mod('roofsie_sidebar_download_text', __('Download our broucher', 'roofsie')), 'roofsie_allowed_tags'); ?></a>
                    </div>
                </div>
            </div>
            <div class="col-xl-8 col-lg-7">
                <div class="service-details__right">
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="service-details__img">
                            <?php the_post_thumbnail('roofsie_service_details_770X470'); ?>
                        </div>
                    <?php endif; ?>
                    <div class="service-details__content">
                        <h2 class="service-details__title"><?php echo strip_tags(get_the_title()); ?></h2>
                        <?php the_content(); ?>
                    </div>
                    <?php $quttiz_feature_box = get_post_meta(get_the_ID(), 'roofsie_service_feature_box', true); ?>
                    <?php if (is_array($quttiz_feature_box) && !empty($quttiz_feature_box)) : ?>
                        <div class="service-details__bottom">
                            <ul class="list-unstyled service-details__bottom-list ml-0">
                                <?php foreach ($quttiz_feature_box as $item) : ?>
                                    <li class="service-details__bottom-single">
                                        <div class="service-details__bottom-icon">
                                            <?php
                                            $roofsie_portfolio_fontawesome = '';
                                            if ('yes' == $item['roofsie_feature_is_fontawesome']) {
                                                $roofsie_portfolio_fontawesome = $item['roofsie_feature_fontawesome_type'];
                                            }
                                            ?>
                                            <span class="<?php echo esc_attr($item['roofsie_feature_box_icon'] . ' ' . $roofsie_portfolio_fontawesome); ?>"></span>
                                            <h4 class="service-details__bottom-title"><?php echo esc_html($item['roofsie_feature_box_title']); ?></h4>
                                            <p class="service-details__bottom-text"><?php echo wp_kses($item['roofsie_feature_box_content'], 'roofsie_allowed_tags'); ?></p>
                                        </div>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <div class="service-details__benefits">
                        <div class="row">
                            <div class="col-xl-6">
                                <div class="service-details__benefits-content">
                                    <?php if (!empty(get_post_meta(get_the_ID(), 'roofsie_service_benefit_title', true))) : ?>
                                        <h3 class="service-details__benefits-title"><?php echo esc_html(get_post_meta(get_the_ID(), 'roofsie_service_benefit_title', true)); ?></h3>
                                    <?php endif; ?>
                                    <?php if (!empty(get_post_meta(get_the_ID(), 'roofsie_service_benefit_summary', true))) : ?>
                                        <p class="service-details__benefits-text"><?php echo esc_html(get_post_meta(get_the_ID(), 'roofsie_service_benefit_summary', true)); ?></p>
                                    <?php endif; ?>
                                    <?php $quttiz_service_checklist = get_post_meta(get_the_ID(), 'roofsie_service_checklist', true); ?>
                                    <?php if (!empty($quttiz_service_checklist) && is_array($quttiz_service_checklist)) : ?>
                                        <ul class="list-unstyled service-details__benefits-list ml-0">
                                            <?php foreach ($quttiz_service_checklist as $checklist) : ?>
                                                <li>
                                                    <div class="icon">
                                                        <span class="icon-draw-check-mark"></span>
                                                    </div>
                                                    <div class="text">
                                                        <p><?php echo esc_html($checklist['roofsie_checklist_title']); ?></p>
                                                    </div>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php $quttiz_service_benefit_img = get_post_meta(get_the_ID(), 'roofsie_benefit_image', true); ?>
                            <?php if (!empty($quttiz_service_benefit_img)) : ?>
                                <div class="col-xl-6">
                                    <div class="service-details__benefits-img">
                                        <img src="<?php echo esc_url($quttiz_service_benefit_img); ?>" alt="<?php the_title(); ?>">
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <?php $quttiz_faq = get_post_meta(get_the_ID(), 'roofsie_service_faq', true); ?>
                    <?php if (!empty($quttiz_faq) && is_array($quttiz_faq)) : ?>
                        <div class="service-details__faq">
                            <div class="accrodion-grp" data-grp-name="faq-one-accrodion">
                                <?php $i = 1;
                                foreach ($quttiz_faq as $item) : ?>
                                    <div class="accrodion <?php echo esc_attr(($i == 1 ? 'active' : ''));  ?>">
                                        <div class="accrodion-title">
                                            <h4><?php echo wp_kses($item['roofsie_faq_question'], 'roofsie_allowed_tags'); ?></h4>
                                        </div>
                                        <div class="accrodion-content">
                                            <div class="inner">
                                                <p><?php echo wp_kses($item['roofsie_faq_answer'], 'roofsie_allowed_tags'); ?></p>
                                            </div><!-- /.inner -->
                                        </div>
                                    </div>
                                <?php $i++;
                                endforeach; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
get_footer();
