<?php $roofsie_portfolio_category =  get_the_terms(get_the_ID(), 'portfolio_cat'); ?>
<?php get_header(); ?>

<!--Portfolio Details Start-->
<section class="portfolio-details">
    <div class="container">
        <div class="row">
            <div class="col-xl-12">
                <div class="portfolio-details__img-box">
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="portfolio-details__img">
                            <?php the_post_thumbnail('roofsie_portfolio_1170X472'); ?>
                        </div>
                    <?php endif; ?>
                    <div class="portfolio-details__details-box">
                        <ul class="list-unstyled portfolio-details__details-list ml-0">
                            <li>
                                <p class="portfolio-details__client"><?php esc_html_e('Clients', 'roofsie-addon'); ?>:</p>
                                <h4 class="portfolio-details__name"><?php echo esc_html(get_post_meta(get_the_ID(), 'roofsie_portfolio_client', true)); ?></h4>
                            </li>
                            <li>
                                <p class="portfolio-details__client"><?php esc_html_e('Category', 'roofsie-addon'); ?>:</p>
                                <h4 class="portfolio-details__name">
                                    <?php foreach ($roofsie_portfolio_category as $cat) {
                                        echo '<span class="category">' . esc_attr($cat->name) . '</span>';
                                    } ?>
                                </h4>
                            </li>
                            <li>
                                <p class="portfolio-details__client"><?php esc_html_e('Date', 'roofsie-addon'); ?>:</p>
                                <h4 class="portfolio-details__name"><?php echo esc_html(get_post_meta(get_the_ID(), 'roofsie_portfolio_date', true)); ?></h4>
                            </li>
                            <?php $roofsie_social_network = get_post_meta(get_the_ID(), 'roofsie_portfolio_social_network', true);  ?>
                            <?php if (is_array($roofsie_social_network) && !empty($roofsie_social_network)) : ?>
                                <li>
                                    <div class="portfolio-details__social">
                                        <?php foreach ($roofsie_social_network as $item) :  ?>
                                            <?php
                                            $roofsie_portfolio_social_network_fontawesome = '';
                                            if ('yes' == $item['roofsie_social_network_is_fontawesome']) {
                                                $roofsie_portfolio_social_network_fontawesome = $item['roofsie_social_network_fontawesome_type'];
                                            }
                                            ?>
                                            <a href="<?php echo esc_url($item['roofsie_social_network_url']); ?>"><i class="<?php echo esc_attr($item['roofsie_social_network_icon'] . ' ' . $roofsie_portfolio_social_network_fontawesome); ?>"></i></a>
                                        <?php endforeach; ?>
                                    </div>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
                <div class="portfolio-details__content-one">
                    <h3><?php the_title(); ?></h3>
                    <?php the_content(); ?>
                </div>
                <?php
                $roofsie_prev_post = get_previous_post();


                $roofsie__next_post = get_next_post();

                ?>
                <div class="portfolio-details__pagination-box">
                    <ul class="portfolio-details__pagination list-unstyled clearfix ml-0">
                        <?php if ($roofsie_prev_post) : ?>
                            <li class="next">
                                <a href="<?php echo esc_url(get_permalink($roofsie_prev_post->ID)); ?>" aria-label="<?php esc_attr_e('Previous', 'roofsie-addon'); ?>"><i class="fa fa-angle-left"></i><?php esc_html_e('Previous', 'roofsie-addon'); ?></a>
                            </li>
                        <?php endif; ?>
                        <li class="count"><a href="#"></a></li>
                        <li class="count"><a href="#"></a></li>
                        <li class="count"><a href="#"></a></li>
                        <li class="count"><a href="#"></a></li>
                        <?php if ($roofsie__next_post) : ?>
                            <li class="previous">
                                <a href="<?php echo esc_url(get_permalink($roofsie__next_post->ID)); ?>" aria-label="<?php esc_attr_e('Next', 'roofsie-addon'); ?>"><?php esc_html_e('Next', 'roofsie-addon'); ?><i class="fa fa-angle-right"></i></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>

            </div>
        </div>
    </div>
</section>
<!--Portfolio Details End-->

<?php get_footer(); ?>