<?php

namespace Layerdrops\Roofsie\Widgets;


class WorkProcess extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'roofsie-work-process';
	}

	public function get_title()
	{
		return __('Work Process', 'roofsie-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['roofsie-category'];
	}

	protected function register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'roofsie-addon'),
				]
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'content_section',
			[
				'label' => __('Content', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => 'layout_one'
				]
			]
		);

		$work_process_items = new \Elementor\Repeater();

		$work_process_items->add_control(
			'title',
			[
				'label' => __('Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Detail <br> proposal', 'roofsie-addon'),
				'label_block' => true,
			]
		);

		$work_process_items->add_control(
			'content',
			[
				'label' => __('Content', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __('Awesome Content', 'roofsie-addon'),
				'label_block' => true,
			]
		);

		$work_process_items->add_control(
			'icon',
			[
				'label' => __('Icon', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-approved',
					'library' => 'custom-icon',
				],
			]
		);


		$work_process_items->add_control(
			'shape',
			[
				'label' => __('Shape', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);


		$this->add_control(
			'work_process_items',
			[
				'label' => __('Work Process Items', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $work_process_items->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
			]
		);

		$this->add_control(
			'bg_image',
			[
				'label' => __('Background Image', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->end_controls_section();


		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		roofsie_typo_and_color_options($this, 'Title', '{{WRAPPER}} .process__title', ['layout_one']);
		roofsie_typo_and_color_options($this, 'Content', '{{WRAPPER}} .process__text', ['layout_one']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include roofsie_get_template('work-process-one.php');
	}
}
