<?php

namespace Layerdrops\Roofsie\Widgets;


class Video extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'roofsie-video';
    }

    public function get_title()
    {
        return __('Video', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'sec_title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Title', 'roofsie-addon'),
                'default' => __('Default Title', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'video_url',
            [
                'label' => __('Video Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '#',
                'label_block' => true,
            ]
        );

        $checklist = new \Elementor\Repeater();

        $checklist->add_control(
            'title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('We’ve expert & certified staff', 'roofsie-addon'),
                'label_block' => true,
            ]
        );


        $checklist->add_control(
            'icon',
            [
                'label' => __('Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-tick',
                    'library' => 'custom-icon',
                ],
            ]
        );


        $this->add_control(
            'checklist',
            [
                'label' => __('Check list', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $checklist->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->add_control(
            'shape',
            [
                'label' => __('Background Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => __('Shape', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );


        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Title', '{{WRAPPER}} .trust-company__title', ['layout_one']);

        roofsie_typo_and_color_options($this, 'Check List Text', '{{WRAPPER}} .trust-compay__points li .text p', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('video-one.php');
    }
}
