<?php

namespace Layerdrops\Roofsie\Widgets;


class Testimonials extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'roofsie-testimonials';
    }

    public function get_title()
    {
        return __('Testimonials', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),
                    'layout_two' => __('Layout Two', 'roofsie-addon'),
                    'layout_three' => __('Layout Three', 'roofsie-addon'),
                    'layout_four' => __('Layout Four', 'roofsie-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );



        $this->add_control(
            'sec_title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Awesome Title', 'roofsie-addon'),
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two']
                ]
            ]
        );

        $this->add_control(
            'sec_sub_title',
            [
                'label' => __('Sub Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default Text', 'roofsie-addon'),
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two']
                ]
            ]
        );

        $this->add_control(
            'sec_sub_image',
            [
                'label' => __('Sub Title Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two']
                ]
            ]
        );

        $testimonial = new \Elementor\Repeater();

        $testimonial->add_control(
            'name',
            [
                'label' => __('Namd', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Kevin Martin', 'roofsie-addon'),
                'label_block' => true
            ]
        );


        $testimonial->add_control(
            'designation',
            [
                'label' => __('Sub Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Marketing Manager', 'roofsie-addon'),
                'label_block' => true
            ]
        );

        $testimonial->add_control(
            'testimonial',
            [
                'label' => __('Testimonial', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default Testimonial Content', 'roofsie-addon'),
            ]
        );

        $testimonial->add_control(
            'rating',
            [
                'label' => __('Rating', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 1,
                        'max' => 5,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 5,
                ],
            ]
        );


        $testimonial->add_control(
            'image',
            [
                'label' => __('Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );


        $this->add_control(
            'testimonials',
            [
                'label' => __('Testimonial Items', 'roofsie-addon'),
                'prevent_empty' => false,
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $testimonial->get_controls(),
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => __('Background Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two']
                ]
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two']);
        roofsie_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .section-sub-title', ['layout_one', 'layout_two']);

        roofsie_typo_and_color_options($this, 'Name', '{{WRAPPER}} .testimonial-one__client-name', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        roofsie_typo_and_color_options($this, 'Designation', '{{WRAPPER}} .testimonial-one__client-sub-title', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        roofsie_typo_and_color_options($this, 'Content', '{{WRAPPER}} .testimonial-one__text', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);

        $this->end_controls_section();

        roofsie_get_elementor_carousel_options($this, ['layout_one', 'layout_two', 'layout_four']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('testimonials-one.php');
        include roofsie_get_template('testimonials-two.php');
        include roofsie_get_template('testimonials-three.php');
        include roofsie_get_template('testimonials-four.php');
    }
}
