<?php

namespace Layerdrops\Roofsie\Widgets;


class Team extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'roofsie-team';
    }

    public function get_title()
    {
        return __('Team', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),
                    'layout_two' => __('Layout Two', 'roofsie-addon'),
                    'layout_three' => __('Layout Three', 'roofsie-addon'),
                    'layout_four' => __('Layout Four', 'roofsie-addon'),
                    'layout_five' => __('Layout Five', 'roofsie-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_content',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_five']
                ]
            ]
        );

        $this->add_control(
            'sec_title',
            [
                'label' => __('Section Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Title', 'roofsie-addon'),
                'default' => __('Default Title', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'sec_sub_title',
            [
                'label' => __('Section Sub Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Sub Title', 'roofsie-addon'),
                'default' => __('Default Title', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'sub_title_image',
            [
                'label' => __('Sub Title Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $team = new \Elementor\Repeater();

        $team->add_control(
            'name',
            [
                'label' => __('Name', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Mike Hardson', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $team->add_control(
            'url',
            [
                'label' => __('Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $team->add_control(
            'designation',
            [
                'label' => __('Designation', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Director', 'roofsie-addon'),
            ]
        );


        $team->add_control(
            'social_network',
            [
                'label' => __('Social NetWork', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::CODE,
                'label_block' => true,
                'default' => wp_kses('<li><a href="#"><i class="fab fa-facebook-square"></i></a></li>', 'roofsie_allowed_tags')
            ]
        );

        $team->add_control(
            'image',
            [
                'label' => __('Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $team->add_control(
            'shape',
            [
                'label' => __('Shape', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );


        $this->add_control(
            'team_items',
            [
                'label' => __('Team', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $team->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'layout_two_content',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => ['layout_two', 'layout_three']
                ]
            ]
        );

        $layout_two_team = new \Elementor\Repeater();

        $layout_two_team->add_control(
            'name',
            [
                'label' => __('Name', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Mike Hardson', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $layout_two_team->add_control(
            'url',
            [
                'label' => __('Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $layout_two_team->add_control(
            'designation',
            [
                'label' => __('Designation', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Director', 'roofsie-addon'),
            ]
        );


        $layout_two_team->add_control(
            'social_network',
            [
                'label' => __('Social NetWork', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::CODE,
                'label_block' => true,
                'default' => wp_kses('<li><a href="#"><i class="fab fa-facebook-square"></i></a></li>', 'roofsie_allowed_tags')
            ]
        );

        $layout_two_team->add_control(
            'image',
            [
                'label' => __('Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $layout_two_team->add_control(
            'shape',
            [
                'label' => __('Shape', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );


        $this->add_control(
            'layout_two_team_items',
            [
                'label' => __('Team', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $layout_two_team->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'layout_four_content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => ['layout_four']
                ]
            ]
        );

        $this->add_control(
            'layout_four_name',
            [
                'label' => __('Name', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Jessica brown', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'layout_four_designation',
            [
                'label' => __('Designation', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Co founder & CEO ', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'layout_two_designation_image',
            [
                'label' => __('Designation Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->add_control(
            'layout_four_highlighted_text',
            [
                'label' => __('Highlighted Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default Text', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'layout_four_content',
            [
                'label' => __('Content', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
            ]
        );

        $this->add_control(
            'big_text',
            [
                'label' => __('Big Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('jessica', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button_label',
            [
                'label' => __('Button Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __(' Contact with me', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button_url',
            [
                'label' => __('Button Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'layout_four_image',
            [
                'label' => __('Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $social_icons = new \Elementor\Repeater();

        $social_icons->add_control(
            'social_icon',
            [
                'label' => __('Select Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook',
                    'library' => 'custom-icon',
                ],
                'label_block' => true,
            ]
        );

        $social_icons->add_control(
            'social_url',
            [
                'label' => __('Add Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'social_icons',
            [
                'label' => __('Social Icons', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $social_icons->get_controls(),
                'prevent_empty' => false,
                'default' => [
                    [
                        'social_url' => [
                            'url' => '#',
                            'is_external' => true,
                            'nofollow' => true,
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_five']);
        roofsie_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .section-sub-title', ['layout_one', 'layout_five']);

        roofsie_typo_and_color_options($this, 'Name', '{{WRAPPER}} .team-one__name a,{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        roofsie_typo_and_color_options($this, 'Designation', '{{WRAPPER}} .team-one__sub-title, {{WRAPPER}} .section-sub-title', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);

        roofsie_typo_and_color_options($this, 'Highlight Text', '{{WRAPPER}} .team-details__text-1', ['layout_four']);

        roofsie_typo_and_color_options($this, 'Content', '{{WRAPPER}} .team-details__text-2, {{WRAPPER}} .team-details__text-3', ['layout_four']);

        roofsie_typo_and_color_options($this, 'Big Text', '{{WRAPPER}} .team-details__big-text', ['layout_four']);

        roofsie_typo_and_color_options($this, 'Button', '{{WRAPPER}} .thm-btn', ['layout_four']);
        roofsie_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} .thm-btn', ['layout_four'], 'background-color', false);

        $this->end_controls_section();

        roofsie_get_elementor_carousel_options($this, ['layout_three']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('team-one.php');
        include roofsie_get_template('team-two.php');
        include roofsie_get_template('team-three.php');
        include roofsie_get_template('team-four.php');
        include roofsie_get_template('team-five.php');
    }
}
