<?php

namespace Layerdrops\Roofsie\Widgets;


class SidebarPortfolioInfo extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'sidebar-portfolio-info';
    }

    public function get_title()
    {
        return __('Sidebar Portfolio Info', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),

                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $portfolio_info = new \Elementor\Repeater();

        $portfolio_info->add_control(
            'title',
            [
                'label' => __('Add Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Clients:', 'roofsie-addon'),
                'label_block' => true
            ]
        );


        $portfolio_info->add_control(
            'content',
            [
                'label' => __('Add Content', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Jessica Brown', 'roofsie-addon'),
                'label_block' => true
            ]
        );


        $this->add_control(
            'portfolio_info',
            [
                'label' => __('Portfolio Info', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'prevent_empty' => false,
                'fields' => $portfolio_info->get_controls(),
            ]
        );


        $social_icons = new \Elementor\Repeater();

        $social_icons->add_control(
            'social_icon',
            [
                'label' => __('Select Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'brands',
                ],
            ]
        );

        $social_icons->add_control(
            'social_url',
            [
                'label' => __('Add Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'social_icons',
            [
                'label' => __('Social NetWork', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $social_icons->get_controls(),
                'prevent_empty' => false,
                'default' => [
                    [
                        'social_url' => [
                            'url' => '#',
                            'is_external' => true,
                            'nofollow' => true,
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();



        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Portfolio Info Title', '{{WRAPPER}} .work-details__client', ['layout_one']);
        roofsie_typo_and_color_options($this, 'Portfolio Info Content', '{{WRAPPER}} .work-details__name', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('sidebar-portfolio-info-one.php');
    }
}
