<?php

namespace Layerdrops\Roofsie\Widgets;


class SidebarCallToAction extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'footer-sidebar-call-to-action';
    }

    public function get_title()
    {
        return __('Sidebar Call To Action', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),

                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Add Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default Title', 'roofsie-addon')
            ]
        );

        $this->add_control(
            'call_text',
            [
                'label' => __('Call Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Call Anytime', 'roofsie-addon')
            ]
        );

        $this->add_control(
            'call_number',
            [
                'label' => __('Call Number', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('+ 1- (246) 333-0088', 'roofsie-addon')
            ]
        );

        $this->add_control(
            'call_url',
            [
                'label' => __('Call Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '#'
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => __('Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-phone-call',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $this->add_control(
            'background_image',
            [
                'label' => __('Background Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        //title typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'title_typography',
                'label'          => esc_html__('Title Typography', 'roofsie-addon'),
                'selector'       => '{{WRAPPER}} .service-details__need-help-title',
            ]
        );

        //title Color
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Title Color', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-details__need-help-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        //call text typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'call_text_typography',
                'label'          => esc_html__('Call Text Typography', 'roofsie-addon'),
                'selector'       => '{{WRAPPER}} .service-details__need-help-contact p',
            ]
        );

        //Call Text Color
        $this->add_control(
            'call_text_color',
            [
                'label' => esc_html__('Call Text Color', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-details__need-help-contact p' => 'color: {{VALUE}}',
                ],
            ]
        );

        //call number typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'call_number_typography',
                'label'          => esc_html__('Call Number Typography', 'roofsie-addon'),
                'selector'       => '{{WRAPPER}} .service-details__need-help-contact a',
            ]
        );

        //Call Text Color
        $this->add_control(
            'call_number_color',
            [
                'label' => esc_html__('Call Number Color', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-details__need-help-contact a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('sidebar-call-to-action-one.php');
    }
}
