<?php

namespace Layerdrops\Roofsie\Widgets;


class Service extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'roofsie-service';
    }

    public function get_title()
    {
        return __('Service', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),
                    'layout_two' => __('Layout Two', 'roofsie-addon'),
                    'layout_three' => __('Layout Three', 'roofsie-addon'),
                    'layout_four' => __('Layout Four', 'roofsie-addon'),
                    'layout_five' => __('Layout Five', 'roofsie-addon'),
                    'layout_six' => __('Layout Six', 'roofsie-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );

        $service_item = new \Elementor\Repeater();

        $service_item->add_control(
            'title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses(__('Quality <br> materials', 'roofsie-addon'), 'roofsie_allowed_tags'),
                'label_block' => true,
            ]
        );


        $service_item->add_control(
            'content',
            [
                'label' => __('Content', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Awesome Content', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $service_item->add_control(
            'button_label',
            [
                'label' => __('Button Label', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('read more', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $service_item->add_control(
            'url',
            [
                'label' => __('Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $service_item->add_control(
            'icon',
            [
                'label' => __('Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-roof-5',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $this->add_control(
            'service_item',
            [
                'label' => __('Service Items', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $service_item->get_controls(),
                'prevent_empty' => false,
                'default' => [
                    [
                        'title' => __('Plumbing Service', 'roofsie-addon'),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->add_control(
            'bg',
            [
                'label' => __('Background Overlay', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );


        $this->end_controls_section();

        //layout_two
        $this->start_controls_section(
            'layout_two_content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'layout_type' => 'layout_two'
                ]
            ]
        );

        $this->add_control(
            'layout_two_sec_title',
            [
                'label' => __('Section Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Awesome Title', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'layout_two_sec_sub_title',
            [
                'label' => __('Section Sub Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Awesome  sub title', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'layout_two_sub_title_image',
            [
                'label' => __('Sub Title Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->add_control(
            'layout_two_summary_text',
            [
                'label' => __('Summary Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default Summary Text', 'roofsie-addon'),
            ]
        );

        $layout_two_service_item = new \Elementor\Repeater();

        $layout_two_service_item->add_control(
            'title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Single play roofing', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $layout_two_service_item->add_control(
            'content',
            [
                'label' => __('Content', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Awesome Content', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $layout_two_service_item->add_control(
            'icon',
            [
                'label' => __('Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-roof',
                    'library' => 'custom-icon',
                ],
            ]
        );


        $layout_two_service_item->add_control(
            'button_label',
            [
                'label' => __('Button label', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Read More ', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $layout_two_service_item->add_control(
            'url',
            [
                'label' => __('Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $layout_two_service_item->add_control(
            'image',
            [
                'label' => __('Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->add_control(
            'layout_two_service_item',
            [
                'label' => __('Service Items', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $layout_two_service_item->get_controls(),
                'prevent_empty' => false,
                'default' => [
                    [
                        'title' => __('Single play roofing', 'roofsie-addon'),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->add_control(
            'layout_two_shape_one',
            [
                'label' => __('Shapes One', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->add_control(
            'layout_two_shape_two',
            [
                'label' => __('Shapes Two', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->end_controls_section();

        //layout_three
        $this->start_controls_section(
            'layout_three_content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'layout_type' => 'layout_three'
                ]
            ]
        );

        $this->add_control(
            'layout_three_sec_title',
            [
                'label' => __('Section Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Awesome Title', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'layout_three_sec_sub_title',
            [
                'label' => __('Section Sub Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Add sub title', 'roofsie-addon'),
            ]
        );


        $this->add_control(
            'layout_three_sub_title_image',
            [
                'label' => __('Sub Title Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $layout_three_service_item = new \Elementor\Repeater();

        $layout_three_service_item->add_control(
            'title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses(__('Single play <br> roofing', 'roofsie-addon'), 'roofsie_allowed_tags'),
                'label_block' => true,
            ]
        );


        $layout_three_service_item->add_control(
            'icon',
            [
                'label' => __('Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-roof',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $layout_three_service_item->add_control(
            'button_label',
            [
                'label' => __('Button Label', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('MORE', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $layout_three_service_item->add_control(
            'url',
            [
                'label' => __('Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'layout_three_service_item',
            [
                'label' => __('Service Items', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $layout_three_service_item->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->add_control(
            'layout_three_shape',
            [
                'label' => __('Shapes', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
                'condition'   => [
                    'layout_type' => 'layout_three'
                ]
            ]
        );

        $this->end_controls_section();

        //layout_four
        $this->start_controls_section(
            'layout_four_content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'layout_type' => 'layout_four'
                ]
            ]
        );

        $this->add_control(
            'layout_four_sec_title',
            [
                'label' => __('Section Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Awesome Title', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'layout_four_sec_sub_title',
            [
                'label' => __('Section Sub Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Add sub title', 'roofsie-addon'),
            ]
        );


        $this->add_control(
            'layout_four_sub_title_image',
            [
                'label' => __('Sub Title Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $layout_four_service_item = new \Elementor\Repeater();

        $layout_four_service_item->add_control(
            'title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Single play roofing', 'roofsie-addon'),
                'label_block' => true,
            ]
        );
        $layout_four_service_item->add_control(
            'url',
            [
                'label' => __('Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );


        $layout_four_service_item->add_control(
            'tagline',
            [
                'label' => __('Tag Line', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Service v1', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $layout_four_service_item->add_control(
            'icon',
            [
                'label' => __('Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-roof',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $layout_four_service_item->add_control(
            'image',
            [
                'label' => __('Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->add_control(
            'layout_four_service_item',
            [
                'label' => __('Service Items', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $layout_four_service_item->get_controls(),
                'prevent_empty' => false,
                'default' => [
                    [
                        'title' => __('Plumbing Service', 'roofsie-addon'),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

        //layout_five
        $this->start_controls_section(
            'layout_five_content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'layout_type' => ['layout_five', 'layout_six']
                ]
            ]
        );


        $layout_five_service_item = new \Elementor\Repeater();

        $layout_five_service_item->add_control(
            'title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Single play roofing', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $layout_five_service_item->add_control(
            'content',
            [
                'label' => __('Content', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Awesome Content', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $layout_five_service_item->add_control(
            'icon',
            [
                'label' => __('Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-roof',
                    'library' => 'custom-icon',
                ],
            ]
        );


        $layout_five_service_item->add_control(
            'button_label',
            [
                'label' => __('Button label', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Read More ', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $layout_five_service_item->add_control(
            'url',
            [
                'label' => __('Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $layout_five_service_item->add_control(
            'image',
            [
                'label' => __('Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->add_control(
            'layout_five_service_item',
            [
                'label' => __('Service Items', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $layout_five_service_item->get_controls(),
                'prevent_empty' => false,
                'default' => [
                    [
                        'title' => __('Single play roofing', 'roofsie-addon'),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();


        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_two', 'layout_three', 'layout_four']);
        roofsie_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .section-sub-title', ['layout_two', 'layout_three', 'layout_four']);
        roofsie_typo_and_color_options($this, 'Summary', '{{WRAPPER}} .services-one__top-right-text', ['layout_two']);

        roofsie_typo_and_color_options($this, 'Service Title', '{{WRAPPER}} .feature-one__title a,{{WRAPPER}} .services-one__title a,{{WRAPPER}} .services-two__title a,{{WRAPPER}} .services-three__title a', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six']);

        roofsie_typo_and_color_options($this, 'Service Content', '{{WRAPPER}} p.services-one__text, {{WRAPPER}} .feature-one__text', ['layout_one', 'layout_two', 'layout_five', 'layout_six']);

        roofsie_typo_and_color_options($this, 'Service Tagline', '{{WRAPPER}} .services-three__sub-title', ['layout_four']);

        roofsie_typo_and_color_options($this, 'Button', '{{WRAPPER}} .feature-one__read-more a,{{WRAPPER}} .services-one__read-more a,{{WRAPPER}} .services-two__read-more a', ['layout_one', 'layout_two', 'layout_three', 'layout_five', 'layout_six']);

        $this->end_controls_section();

        roofsie_get_elementor_carousel_options($this, ['layout_six']);
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('service-one.php');
        include roofsie_get_template('service-two.php');
        include roofsie_get_template('service-three.php');
        include roofsie_get_template('service-four.php');
        include roofsie_get_template('service-five.php');
        include roofsie_get_template('service-six.php');
    }
}
