<?php

namespace Layerdrops\Roofsie\Widgets;


class ProgressBar extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'roofsie-progress-bar';
    }

    public function get_title()
    {
        return __('Progress Bar', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),

                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );


        $progress_bar = new \Elementor\Repeater();

        $progress_bar->add_control(
            'title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Cleaning', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $progress_bar->add_control(
            'count',
            [
                'label' => __('Count', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 85,
                ],
            ]
        );

        $this->add_control(
            'progress_bar_items',
            [
                'label' => __('Progress Bar', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $progress_bar->get_controls(),
                'prevent_empty' => false,
                'default' => [
                    [
                        'title' => __('Cleaning', 'roofsie-addon'),
                    ],
                ],
                'title_field' => '{{{ title }}}',
            ]
        );


        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Title', '{{WRAPPER}} .team-details__progress-title', 'layout_one');
        roofsie_typo_and_color_options($this, 'Progress Bar', '{{WRAPPER}} .team-details__progress .bar-inner', 'layout_one', 'background-color', false);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('progressbar-one.php');
    }
}
