<?php

namespace Layerdrops\Roofsie\Widgets;


class Pricing extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'roofsie-pricing';
    }

    public function get_title()
    {
        return __('Pricing', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'sec_title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Awesome Title', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'sec_sub_title',
            [
                'label' => __('Sub Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default Text', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'sec_sub_image',
            [
                'label' => __('Sub Title Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->add_control(
            'summary',
            [
                'label' => __('Summary', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default Summary Text', 'roofsie-addon'),
            ]
        );

        $price = new \Elementor\Repeater();

        $price->add_control(
            'name',
            [
                'label' => __('Name', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Silver plan', 'roofsie-addon'),
                'label_block' => true
            ]
        );

        $price->add_control(
            'tagline',
            [
                'label' => __('Tag Line', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('*Rates are subject to change', 'roofsie-addon'),
                'label_block' => true
            ]
        );


        $price->add_control(
            'currency',
            [
                'label' => __('Currency', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('$', 'roofsie-addon'),
                'label_block' => true
            ]
        );

        $price->add_control(
            'price',
            [
                'label' => __('Price', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('36', 'roofsie-addon'),
            ]
        );

        $price->add_control(
            'features',
            [
                'label' => __('Enable Features', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::CODE,
                'default' => __(' <li><p>Free Installation</p><i class="fa fa-check"></i></li>', 'roofsie-addon'),
            ]
        );

        $price->add_control(
            'disable_features',
            [
                'label' => __('Disable Features', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::CODE,
                'default' => __('<li><p>Emergency Roof Repair</p><i class="fas fa-times"></i></li>', 'roofsie-addon'),
            ]
        );


        $price->add_control(
            'button_label',
            [
                'label' => __('Button Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __(' Choose plan', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $price->add_control(
            'button_url',
            [
                'label' => __('Button Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );


        $price->add_control(
            'shape_one',
            [
                'label' => __('Shape Image One', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $price->add_control(
            'shape_two',
            [
                'label' => __('Shape Image Two', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->add_control(
            'price',
            [
                'label' => __('Price Items', 'roofsie-addon'),
                'prevent_empty' => false,
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $price->get_controls(),
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => __('Background Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'contact_info',
            [
                'label' => __('Contact Info', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'phone_icon',
            [
                'label' => __('Phone Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-phone-call',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $this->add_control(
            'phone_text',
            [
                'label' => __('Phone Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Book our services', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'phone_number',
            [
                'label' => __('Phone Number', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('+92 (003) 68-090', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'phone_url',
            [
                'label' => __('Phone Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '#'
            ]
        );

        $this->add_control(
            'email_text',
            [
                'label' => __('Email Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Send your email', 'roofsie-addon'),
            ]
        );


        $this->add_control(
            'email_address',
            [
                'label' => __('Email Address', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('supportyou@roofsie.com', 'roofsie-addon'),
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one']);
        roofsie_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .section-sub-title', ['layout_one']);
        roofsie_typo_and_color_options($this, 'Section Summary', '{{WRAPPER}} .pricing-one__text', ['layout_one']);

        roofsie_typo_and_color_options($this, 'Pricing Name', '{{WRAPPER}} .pricing-one__title', ['layout_one']);
        roofsie_typo_and_color_options($this, 'Pricing Tag Line', '{{WRAPPER}} .pricing-one__rate-change', ['layout_one']);
        roofsie_typo_and_color_options($this, 'Pricing Currency', '{{WRAPPER}} .pricing-one__rate span', ['layout_one']);
        roofsie_typo_and_color_options($this, 'Pricing Price', '{{WRAPPER}} .pricing-one__rate', ['layout_one']);
        roofsie_typo_and_color_options($this, 'Pricing Active Features', '{{WRAPPER}} .pricing-one__list-one li p', ['layout_one']);
        roofsie_typo_and_color_options($this, 'Pricing Inactive Features', '{{WRAPPER}} .pricing-one__list-two li p', ['layout_one']);
        roofsie_typo_and_color_options($this, 'Button', '{{WRAPPER}} .pricing-one__btn', ['layout_one']);
        roofsie_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} .pricing-one__btn', ['layout_one'], 'background-color', false);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('price-one.php');
    }
}
