<?php

namespace Layerdrops\Roofsie\Widgets;


class PortfolioPagination extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'portfolio-pagination';
    }

    public function get_title()
    {
        return __('Portfolio Pagination', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function _register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),

                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'prev_txt',
            [
                'label' => __('Previous Post Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Previous post', 'roofsie-addon'),
                'label_block' => true
            ]
        );

        $this->add_control(
            'prev_post_title',
            [
                'label' => __('Previous Post Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Roof inspection', 'roofsie-addon'),
                'label_block' => true
            ]
        );

        $this->add_control(
            'prev_url',
            [
                'label' => __('Previous Post Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );


        $this->add_control(
            'nxt_txt',
            [
                'label' => __('Next Post Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Next post', 'roofsie-addon'),
                'label_block' => true
            ]
        );

        $this->add_control(
            'nxt_post_title',
            [
                'label' => __('Next Post Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Roof renovation', 'roofsie-addon'),
                'label_block' => true
            ]
        );

        $this->add_control(
            'next_url',
            [
                'label' => __('Next Post Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );


        $this->end_controls_section();



        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Title', '{{WRAPPER}} .work-details__pagination li p', ['layout_one']);
        roofsie_typo_and_color_options($this, 'Prev/Next Button', '{{WRAPPER}} .work-details__pagination li span', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('portfolio-pagination-one.php');
    }
}
