<?php

namespace Layerdrops\Roofsie\Widgets;


class Portfolio extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'roofsie-portfolio';
    }

    public function get_title()
    {
        return __('Portfolio', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),
                    'layout_two' => __('Layout Two', 'roofsie-addon'),
                    'layout_three' => __('Layout Three', 'roofsie-addon'),
                    'layout_four' => __('Layout Four', 'roofsie-addon'),
                    'layout_five' => __('Layout Five', 'roofsie-addon'),
                    'layout_six' => __('Layout Six', 'roofsie-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'section_header',
            [
                'label' => __('Section Header', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_three', 'layout_six']
                ]
            ]
        );

        $this->add_control(
            'sec_title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Title', 'roofsie-addon'),
                'default' => __('Default Title', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'sec_sub_title',
            [
                'label' => __('Sub Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add sub title', 'roofsie-addon'),
                'default' => __('Default Sub Title', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'sub_title_image',
            [
                'label' => __('Sub Title Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );

        $portfolio_item = new \Elementor\Repeater();

        $portfolio_item->add_control(
            'title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses(__('Modern <br> roofing style', 'roofsie-addon'), 'roofsie_allowed_tags'),
                'label_block' => true,
            ]
        );


        $portfolio_item->add_control(
            'url',
            [
                'label' => __('Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $portfolio_item->add_control(
            'image',
            [
                'label' => __('Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'portfolio_item',
            [
                'label' => __('Portfolio Items', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $portfolio_item->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'layout_two_content',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => ['layout_two']
                ]
            ]
        );

        $this->add_control(
            'enable_filter',
            [
                'label' => esc_html__('Enable Filter', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'roofsie-addon'),
                'label_off' => esc_html__('No', 'roofsie-addon'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $filter = new \Elementor\Repeater();

        $filter->add_control(
            'name',
            [
                'label' => __('Filter Name', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Add Filter Name', 'roofsie-addon'),
                'default' => __('Default Name', 'roofsie-addon')
            ]
        );

        $filter->add_control(
            'slug',
            [
                'label' => __('Filter Slug', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Add Filter Slug', 'roofsie-addon'),
                'default' => __('default-slug', 'roofsie-addon')
            ]
        );

        $this->add_control(
            'filter',
            [
                'label' => __('Filter', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'prevent_empty' => false,
                'fields' => $filter->get_controls(),
                'title_field' => '{{{ name }}}',
                'condition' => [
                    'enable_filter' => 'yes'
                ]
            ]
        );


        $layout_two_portfolio_item = new \Elementor\Repeater();

        $layout_two_portfolio_item->add_control(
            'title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses(__('Modern <br> roofing style', 'roofsie-addon'), 'roofsie_allowed_tags'),
                'label_block' => true,
            ]
        );


        $layout_two_portfolio_item->add_control(
            'url',
            [
                'label' => __('Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $layout_two_portfolio_item->add_control(
            'slug',
            [
                'label' => __('Slug', 'slando-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('default-slug', 'slando-addon'),
                'label_block' => true,
            ]
        );

        $layout_two_portfolio_item->add_control(
            'tag_line',
            [
                'label' => __('Tag Line', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Commercial, Residential', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $layout_two_portfolio_item->add_control(
            'icon_image',
            [
                'label' => __('Icon Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );


        $layout_two_portfolio_item->add_control(
            'image',
            [
                'label' => __('Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'layout_two_portfolio_item',
            [
                'label' => __('Portfolio Items', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $layout_two_portfolio_item->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'layout_three_content',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'layout_three'
                ]
            ]
        );

        $layout_three_portfolio_item = new \Elementor\Repeater();

        $layout_three_portfolio_item->add_control(
            'title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Replacement of roof', 'roofsie-addon'),
                'label_block' => true
            ]
        );


        $layout_three_portfolio_item->add_control(
            'url',
            [
                'label' => __('Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $layout_three_portfolio_item->add_control(
            'tag_line',
            [
                'label' => __('Tag Line', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Roof / IDEAS', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $layout_three_portfolio_item->add_control(
            'image',
            [
                'label' => __('Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'layout_three_portfolio_item',
            [
                'label' => __('Portfolio Items', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $layout_three_portfolio_item->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'layout_four_content',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'layout_four'
                ]
            ]
        );

        $this->add_control(
            'layout_four_enable_filter',
            [
                'label' => esc_html__('Enable Filter', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'roofsie-addon'),
                'label_off' => esc_html__('No', 'roofsie-addon'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'layout_type' => 'layout_four'
                ]
            ]
        );

        $layout_four_filter = new \Elementor\Repeater();

        $layout_four_filter->add_control(
            'name',
            [
                'label' => __('Filter Name', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Add Filter Name', 'roofsie-addon'),
                'default' => __('Default Name', 'roofsie-addon')
            ]
        );

        $layout_four_filter->add_control(
            'slug',
            [
                'label' => __('Filter Slug', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Add Filter Slug', 'roofsie-addon'),
                'default' => __('default-slug', 'roofsie-addon')
            ]
        );

        $this->add_control(
            'layout_four_filter',
            [
                'label' => __('Filter', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'prevent_empty' => false,
                'fields' => $filter->get_controls(),
                'title_field' => '{{{ name }}}',
                'condition' => [
                    'enable_filter' => 'yes',
                    'layout_type' => 'layout_four'
                ]
            ]
        );


        $layout_four_portfolio_item = new \Elementor\Repeater();

        $layout_four_portfolio_item->add_control(
            'title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses(__('Modern <br> roofing style', 'roofsie-addon'), 'roofsie_allowed_tags'),
                'label_block' => true,
            ]
        );


        $layout_four_portfolio_item->add_control(
            'url',
            [
                'label' => __('Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $layout_four_portfolio_item->add_control(
            'slug',
            [
                'label' => __('Slug', 'slando-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('default-slug', 'slando-addon'),
                'label_block' => true,
            ]
        );


        $layout_four_portfolio_item->add_control(
            'image',
            [
                'label' => __('Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'layout_four_portfolio_item',
            [
                'label' => __('Portfolio Items', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $layout_four_portfolio_item->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'layout_five_content',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => ['layout_five', 'layout_six']
                ]
            ]
        );

        $layout_five_portfolio_item = new \Elementor\Repeater();

        $layout_five_portfolio_item->add_control(
            'title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => wp_kses(__('Modern <br> roofing style', 'roofsie-addon'), 'roofsie_allowed_tags'),
                'label_block' => true,
            ]
        );


        $layout_five_portfolio_item->add_control(
            'url',
            [
                'label' => __('Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $layout_five_portfolio_item->add_control(
            'image',
            [
                'label' => __('Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'layout_five_portfolio_item',
            [
                'label' => __('Portfolio Items', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $layout_five_portfolio_item->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ title }}}',
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three', 'layout_six']);
        roofsie_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .section-sub-title', ['layout_one', 'layout_two', 'layout_three', 'layout_six']);

        roofsie_typo_and_color_options($this, 'Title', '{{WRAPPER}} .project-one__title a,{{WRAPPER}} .project-two__title a, .project-three__title a', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_six']);
        roofsie_typo_and_color_options($this, 'Tag Line', '{{WRAPPER}} .project-two__sub-title, {{WRAPPER}} .project-three__sub-title', ['layout_two', 'layout_three']);

        $this->end_controls_section();

        roofsie_get_elementor_carousel_options($this, ['layout_one', 'layout_three', 'layout_five', 'layout_six']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('portfolio-one.php');
        include roofsie_get_template('portfolio-two.php');
        include roofsie_get_template('portfolio-three.php');
        include roofsie_get_template('portfolio-four.php');
        include roofsie_get_template('portfolio-five.php');
        include roofsie_get_template('portfolio-six.php');
    }
}
