<?php

namespace Layerdrops\Roofsie\Widgets;


class IconBox extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'roofsie-icon-box';
	}

	public function get_title()
	{
		return __('Icon Box', 'roofsie-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['roofsie-category'];
	}

	protected function register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'roofsie-addon'),
				]
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'content_section',
			[
				'label' => __('Content', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => 'layout_one'
				]
			]
		);


		$layout_one_item = new \Elementor\Repeater();

		$layout_one_item->add_control(
			'text',
			[
				'label' => __('Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __('Default Text', 'roofsie-addon'),
				'label_block' => true,
			]
		);

		$layout_one_item->add_control(
			'icon',
			[
				'label' => __('Icon', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-roof',
					'library' => 'custom-icon',
				],
			]
		);

		$this->add_control(
			'icon_box_items',
			[
				'label' => __('Icon Box Items', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_one_item->get_controls(),
				'prevent_empty' => false,
				'default' => [
					[
						'title' => __('Default Text', 'roofsie-addon'),
					],
				],
				'title_field' => '{{{ text }}}',
			]
		);

		$this->end_controls_section();


		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		roofsie_typo_and_color_options($this, 'Text', '{{WRAPPER}} .service-details__points-content p', 'layout_one');

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include roofsie_get_template('icon-box-one.php');
	}
}
