<?php

namespace Layerdrops\Roofsie\Widgets;


class Header extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'roofsie-header';
    }

    public function get_title()
    {
        return __('Header', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout Type', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),
                    'layout_two' => __('Layout Two', 'roofsie-addon'),
                    'layout_three' => __('Layout Three', 'roofsie-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'logo_section',
            [
                'label' => __('Site Logo', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'light_logo',
            [
                'label' => __('Light Logo', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'logo_dimension',
            [
                'label' => __('Logo Dimension', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
                'description' => __('Set Custom Logo Size.', 'roofsie-addon'),
                'default' => [
                    'width' => '134',
                    'height' => '34',
                ],
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'nav_section',
            [
                'label' => __('Navigation', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'one_page_status',
            [
                'label' => __('Enable One Page Menu?', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'roofsie-addon'),
                'label_off' => __('No', 'roofsie-addon'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'nav_menu',
            [
                'label' => __('Select Nav Menu', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => roofsie_get_nav_menu(),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'others_section',
            [
                'label' => __('Others', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'search_status',
            [
                'label' => __('Enable Search?', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'roofsie-addon'),
                'label_off' => __('No', 'roofsie-addon'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'top_bar_text',
            [
                'label' => __('Top Bar Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('We provide complete home renovation services.', 'roofsie-addon'),
                'label_block' => true,
                'condition' => [
                    'layout_type' => ['layout_two', 'layout_three']
                ]
            ]
        );

        $this->add_control(
            'call_icon',
            [
                'label' => __('Call Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-phone',
                    'library' => 'brands',
                ],
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_three']
                ]
            ]
        );

        $this->add_control(
            'call_text',
            [
                'label' => __('Call Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('CALL ANYTIME ', 'roofsie-addon'),
                'label_block' => true,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_three']
                ]
            ]
        );

        $this->add_control(
            'call_number',
            [
                'label' => __('Call Number', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('666 000 888', 'roofsie-addon'),
                'label_block' => true,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_three']
                ]
            ]
        );

        $this->add_control(
            'call_url',
            [
                'label' => __('Call Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '#',
                'label_block' => true,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_three']
                ]
            ]
        );


        $topbar_info = new \Elementor\Repeater();

        $topbar_info->add_control(
            'text',
            [
                'label' => __('Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Mon to Sat: 09:00 am to 05:00 pm', 'roofsie-addon')
            ]
        );

        $topbar_info->add_control(
            'icon',
            [
                'label' => __('Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-clock',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $this->add_control(
            'topbar_info',
            [
                'label' => __('Contact Info', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $topbar_info->get_controls(),
                'prevent_empty' => false,
                'condition' => [
                    'layout_type' => 'layout_one'
                ],
            ]
        );

        $topbar_menu = new \Elementor\Repeater();

        $topbar_menu->add_control(
            'menu',
            [
                'label' => __('Menu Name', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Our Faqs', 'roofsie-addon'),
                'label_blok' => true
            ]
        );


        $topbar_menu->add_control(
            'url',
            [
                'label' => __('Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'topbar_menu',
            [
                'label' => __('Top bar Menu', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $topbar_menu->get_controls(),
                'prevent_empty' => false,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_three']
                ],
            ]
        );

        $this->add_control(
            'button_label',
            [
                'label' => __('Button Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __(' Free estimate', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button_url',
            [
                'label' => __('Button Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $layout_two_contact_info = new \Elementor\Repeater();

        $layout_two_contact_info->add_control(
            'title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Call Anytime', 'roofsie-addon')
            ]
        );


        $layout_two_contact_info->add_control(
            'content',
            [
                'label' => __('Content', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => wp_kses(__('<a href="tel:9200368090">+92 (003) 68-090</a>', 'roofsie-addon'), 'roofsie_allowed_tags')
            ]
        );

        $layout_two_contact_info->add_control(
            'icon',
            [
                'label' => __('Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-phone-call',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $this->add_control(
            'layout_two_contact_info',
            [
                'label' => __('Contact Info', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $layout_two_contact_info->get_controls(),
                'prevent_empty' => false,
                'condition' => [
                    'layout_type' => ['layout_two', 'layout_three']
                ],
            ]
        );

        $social_icons = new \Elementor\Repeater();

        $social_icons->add_control(
            'social_icon',
            [
                'label' => __('Select Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'brands',
                ],
            ]
        );

        $social_icons->add_control(
            'social_url',
            [
                'label' => __('Add Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'social_icons',
            [
                'label' => __('Social NetWork', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $social_icons->get_controls(),
                'prevent_empty' => false,
                'default' => [
                    [
                        'social_url' => [
                            'url' => '#',
                            'is_external' => true,
                            'nofollow' => true,
                        ],
                    ],
                ],
            ]
        );

        $this->add_control(
            'layout_three_bg_image',
            [
                'label' => __('Background Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
                'condition' => [
                    'layout_type' => 'layout_three'
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'mobile_menu_section',
            [
                'label' => __('Mobile Drawer', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'mobile_menu_logo',
            [
                'label' => __('Mobile Drawer Logo', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );



        $this->add_control(
            'mobile_menu_email',
            [
                'label' => __('Email Address', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('email@eamil.com', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'mobile_menu_phone',
            [
                'label' => __('Phone Number', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('323232', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $mobile_menu_social_icons = new \Elementor\Repeater();

        $mobile_menu_social_icons->add_control(
            'social_icon',
            [
                'label' => __('Select Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'brands',
                ],
                'label_block' => true,
            ]
        );

        $mobile_menu_social_icons->add_control(
            'social_url',
            [
                'label' => __('Add Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'mobile_menu_social_icons',
            [
                'label' => __('Social Icons', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'prevent_empty' => false,
                'fields' => $mobile_menu_social_icons->get_controls(),
                'default' => [
                    [
                        'social_icon' => 'fa-facebook-f',
                        'social_url' => [
                            'url' => '#',
                            'is_external' => true,
                            'nofollow' => true,
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Nav Menu', '{{WRAPPER}} .main-menu .main-menu__list > li > a, .stricky-header .main-menu__list > li > a', ['layout_one', 'layout_two', 'layout_three']);

        roofsie_typo_and_color_options($this, 'Top Bar', '{{WRAPPER}} .main-header__top-address-list li .text p,{{WRAPPER}} .main-header-three__top-left-text, 
        {{WRAPPER}}  .main-header__top-address-list li .text p a,{{WRAPPER}} .main-header__top-menu li a,{{WRAPPER}} .main-header-two__top-left-text,{{WRAPPER}} .main-header-three__top-menu li a', ['layout_one', 'layout_two', 'layout_three']);

        roofsie_typo_and_color_options($this, 'Contact Info Title', '{{WRAPPER}} .main-header-two__address-list li .content p,{{WRAPPER}} .main-header-three__address-list li .content p', ['layout_two', 'layout_three']);
        roofsie_typo_and_color_options($this, 'Contact Info Text', '{{WRAPPER}} .main-header-two__address-list li .content h5 a,{{WRAPPER}} .main-header-three__address-list li .content h5 a', ['layout_two', 'layout_three']);

        roofsie_typo_and_color_options($this, 'Call Text', '{{WRAPPER}} .main-menu__call-content p', ['layout_one']);

        roofsie_typo_and_color_options($this, 'Call Number', '{{WRAPPER}} .main-menu__call-content a', ['layout_one']);


        roofsie_typo_and_color_options($this, 'Button', '{{WRAPPER}} .thm-btn', ['layout_one', 'layout_two', 'layout_three']);
        roofsie_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} .thm-btn', ['layout_one', 'layout_two', 'layout_three'], 'background-color', false);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('header.php');
    }
}
