<?php

namespace Layerdrops\Roofsie\Widgets;


class Funfact extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'roofsie-funfact';
    }

    public function get_title()
    {
        return __('Funfact', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'sec_title',
            [
                'label' => __('Section Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Awesome Title', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'sec_sub_title',
            [
                'label' => __('Section Sub Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Awesome  sub title', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'sub_title_image',
            [
                'label' => __('Sub Title Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $funfact_box = new \Elementor\Repeater();

        $funfact_box->add_control(
            'icon',
            [
                'label' => __('Count Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-roof-3',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $funfact_box->add_control(
            'counter',
            [
                'label' => __('Count Number', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 562,
                'label_block' => true,
            ]
        );

        $funfact_box->add_control(
            'text',
            [
                'label' => __('Count Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default Text', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $funfact_box->add_control(
            'sign',
            [
                'label' => __('Count Sign', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('+', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'funfact_boxes',
            [
                'label' => __('Fun fact Boxes', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $funfact_box->get_controls(),
                'prevent_empty' => false,
                'title_field' => '{{{ text }}}',
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .counter-one__title', ['layout_one']);
        roofsie_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .counter-one__sub-title', ['layout_one']);

        roofsie_typo_and_color_options($this, 'Count Text', '{{WRAPPER}} .counter-one__text, {{WRAPPER}} .counter-two__text', ['layout_one']);
        roofsie_typo_and_color_options($this, 'Count Number', '{{WRAPPER}} .counter-one__count-box h3,{{WRAPPER}} .counter-one__plus', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('funfact-one.php');
    }
}
