<?php

namespace Layerdrops\Roofsie\Widgets;


class FooterSubscribe extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'footer-subscribe';
    }

    public function get_title()
    {
        return __('Footer Subscribe', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Widget Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Explore', 'roofsie-addon')
            ]
        );

        $this->add_control(
            'paragraph_text',
            [
                'label' => __('Paragraph Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default Paragraph Text', 'roofsie-addon')
            ]
        );

        $this->add_control(
            'mailchimp_url',
            [
                'label' => __('Add Mailchimp URL', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '#',
            ]
        );

        $this->add_control(
            'mc_input_placeholder',
            [
                'label' => __('Input Placeholder Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Email Address', 'roofsie-addon')
            ]
        );

        $this->add_control(
            'button_label',
            [
                'label' => __('Button Label', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Subscribe', 'roofsie-addon')
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => __('Submit Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-arrow-right',
                    'library' => 'custom-icon',
                ],
            ]
        );


        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_option',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        //widget title typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'widget_title_typography',
                'label'          => esc_html__('Widget Title Typography', 'roofsie-addon'),
                'selector'       => '{{WRAPPER}} .footer-widget__title',
            ]
        );

        $this->add_control(
            'widget_title__color',
            [
                'label' => __('Widget Title Color', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-widget__title' => 'color: {{VALUE}}',
                ],

            ]
        );

        //Paragraph Text typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'paragraph_text_typography',
                'label'          => esc_html__('Paragraph Text Typography', 'roofsie-addon'),
                'selector'       => '{{WRAPPER}} .footer-widget__newsletter-text',
            ]
        );

        $this->add_control(
            'paragraph_text_color',
            [
                'label' => __('Paragraph Text Color', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-widget__newsletter-text' => 'color: {{VALUE}}',
                ],

            ]
        );

        //Button typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'button_typography',
                'label'          => esc_html__('Button Typography', 'roofsie-addon'),
                'selector'       => '{{WRAPPER}} .thm-btn',
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => __('Button Color', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn' => 'color: {{VALUE}}',
                ],

            ]
        );

        $this->add_control(
            'button_bg_color',
            [
                'label' => __('Button Background Color', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .thm-btn' => 'background-color: {{VALUE}}',
                ],

            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {


        $settings = $this->get_settings_for_display();
        include roofsie_get_template('footer-subscribe-one.php');
    }
}
