<?php

namespace Layerdrops\Roofsie\Widgets;


class FooterNavMenu extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'footer-nav-menu';
    }

    public function get_title()
    {
        return __('Footer Nav Menus', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Add Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Links', 'roofsie-addon')
            ]
        );

        $nav_menus = new \Elementor\Repeater();

        $nav_menus->add_control(
            'nav_menu',
            [
                'label' => __('Select Nav Menu', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => roofsie_get_nav_menu(),
                'label_block' => true,
            ]
        );


        $this->add_control(
            'nav_menus',
            [
                'label' => __('Nav Menus', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'prevent_empty' => false,
                'fields' => $nav_menus->get_controls(),
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_option',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        //Widget title typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'widget_title_typography',
                'label'          => esc_html__('Widget Title Typography', 'roofsie-addon'),
                'selector'       => '{{WRAPPER}} .footer-widget__title',
            ]
        );

        $this->add_control(
            'widget_title__color',
            [
                'label' => __('Widget Title Color', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-widget__title' => 'color: {{VALUE}}',
                ],

            ]
        );

        //Nav text typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'nav_text_typography',
                'label'          => esc_html__('Nav Text Typography', 'roofsie-addon'),
                'selector'       => '{{WRAPPER}} .footer-widget__explore-list li a',
            ]
        );

        $this->add_control(
            'nav_text__color',
            [
                'label' => __('Nav Text Color', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-widget__explore-list li a' => 'color: {{VALUE}}',
                ],

            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('footer-nav-menu.php');
    }
}
