<?php

namespace Layerdrops\Roofsie\Widgets;


class FooterCopyright extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'footer-copyright';
    }

    public function get_title()
    {
        return __('Footer CopyRight', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Add Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('&copy; Layerdrops', 'roofsie-addon')
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_option',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        //Copyright Text typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'copyright_text_typography',
                'label'          => esc_html__('Copyright Text Typography', 'roofsie-addon'),
                'selector'       => '{{WRAPPER}} .site-footer__bottom-text,{{WRAPPER}} .site-footer__bottom-text a',
            ]
        );

        $this->add_control(
            'copyright_text_color',
            [
                'label' => __('Copyright Text Color', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .site-footer__bottom-text,{{WRAPPER}} .site-footer__bottom-text a' => 'color: {{VALUE}}',
                ],

            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('footer-copyright.php');
    }
}
