<?php

namespace Layerdrops\Roofsie\Widgets;


class FooterContact extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'footer-contact';
    }

    public function get_title()
    {
        return __('Footer Contact', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Add Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Contact', 'roofsie-addon'),
                'label_block' => true
            ]
        );

        $this->add_control(
            'paragraph',
            [
                'label' => __('Add Paragraph', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => wp_kses(__('88 Broklyn Golden Road Street, <br> New York. USA', 'roofsie-addon'), 'roofsie_allowed_tags'),
                'label_block' => true
            ]
        );

        $contact_info = new \Elementor\Repeater();

        $contact_info->add_control(
            'content',
            [
                'label' => __('Content', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => wp_kses(__('<a href="mailto:needhelp@company.com ">needhelp@company.com</a>', 'roofsie-addon'), 'roofsie_allowed_tags'),
                'label_block' => true,
            ]
        );

        $contact_info->add_control(
            'icon',
            [
                'label' => __('Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-envelope',
                    'library' => 'custom-icon',
                ],
            ]
        );


        $this->add_control(
            'contact_info',
            [
                'label' => __('Contact Info', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'prevent_empty' => false,
                'fields' => $contact_info->get_controls(),
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_option',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        //Widget title typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'widget_title_typography',
                'label'          => esc_html__('Widget Title Typography', 'roofsie-addon'),
                'selector'       => '{{WRAPPER}} .footer-widget__title',
            ]
        );

        $this->add_control(
            'widget_title__color',
            [
                'label' => __('Widget Title Color', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-widget__title' => 'color: {{VALUE}}',
                ],

            ]
        );

        //paragraph text  typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'paragraph_text_typography',
                'label'          => esc_html__('Paragraph Text Typography', 'roofsie-addon'),
                'selector'       => '{{WRAPPER}} .footer-widget__contact-text',
            ]
        );

        $this->add_control(
            'paragraph_text_color',
            [
                'label' => __('Paragraph Text Color', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-widget__contact-text' => 'color: {{VALUE}}',
                ],

            ]
        );

        //Contact Info  typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name'           => 'contact_info_typography',
                'label'          => esc_html__('Contact Info Typography', 'roofsie-addon'),
                'selector'       => '{{WRAPPER}} .footer-widget__contact-list li .text p a',
            ]
        );

        $this->add_control(
            'contact_info_color',
            [
                'label' => __('Contact Info Color', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-widget__contact-list li .text p a' => 'color: {{VALUE}}',
                ],

            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('footer-contact.php');
    }
}
