<?php

namespace Layerdrops\Roofsie\Widgets;


class Faq extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'roofsie-faq';
	}

	public function get_title()
	{
		return __('FAQ', 'roofsie-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['roofsie-category'];
	}

	protected function register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'roofsie-addon'),
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('Content', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$faq = new \Elementor\Repeater();

		$faq->add_control(
			'question',
			[
				'label' => __('Question', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __('Add Question', 'roofsie-addon'),
				'label_block' => true,
				'default' => __('Default Question', 'roofsie-addon')
			]
		);
		$faq->add_control(
			'answer',
			[
				'label' => __('Answer', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Answer', 'roofsie-addon'),
				'label_block' => true,
				'default' => __('Default Answer', 'roofsie-addon')
			]
		);

		$faq->add_control(
			'active_status',
			[
				'label' => __('Is active?', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'roofsie-addon'),
				'label_off' => __('No', 'roofsie-addon'),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'faq_lists',
			[
				'label' => __('FAQ', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $faq->get_controls(),
				'title_field' => '{{{ question }}}',
			]
		);

		$this->end_controls_section();


		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		roofsie_typo_and_color_options($this, 'Question', '{{WRAPPER}} .faq-one-accrodion .accrodion-title h4', ['layout_one', 'layout_two', 'layout_three']);
		roofsie_typo_and_color_options($this, 'Answer', '{{WRAPPER}} .faq-one-accrodion .accrodion-content p', ['layout_one', 'layout_two', 'layout_three']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include roofsie_get_template('faq-one.php');
	}
}
