<?php

namespace Layerdrops\Roofsie\Widgets;


class FancyBox extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'roofsie-fancybox';
	}

	public function get_title()
	{
		return __('Fancybox', 'roofsie-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['roofsie-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'roofsie-addon'),
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_one_content_section',
			[
				'label' => __('Content', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => ['layout_one']
				]
			]
		);

		$layout_one_item = new \Elementor\Repeater();

		$layout_one_item->add_control(
			'title',
			[
				'label' => __('Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Homepage 01', 'roofsie-addon'),
				'label_block' => true,
			]
		);

		$layout_one_item->add_control(
			'button_one_label',
			[
				'label' => __('Button One Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Multi Page', 'roofsie-addon'),
				'label_block' => true,
			]
		);

		$layout_one_item->add_control(
			'button_one_url',
			[
				'label' => __('Button One Url', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'roofsie-addon'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
				'show_label' => false,
			]
		);

		$layout_one_item->add_control(
			'button_two_label',
			[
				'label' => __('Button One Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('One Page', 'roofsie-addon'),
				'label_block' => true,
			]
		);

		$layout_one_item->add_control(
			'button_two_url',
			[
				'label' => __('Button Two Url', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'roofsie-addon'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
				'show_label' => false,
			]
		);

		$layout_one_item->add_control(
			'image',
			[
				'label' => __('Image', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'layout_one_item',
			[
				'label' => __('Fancy Boxes', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_one_item->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		roofsie_typo_and_color_options($this, 'Title', '{{WRAPPER}} .home-showcase__title', 'layout_one');

		roofsie_typo_and_color_options($this, 'Button', '{{WRAPPER}} .home-showcase__buttons__item', 'layout_one');
		roofsie_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} .home-showcase__buttons__item', 'layout_one', 'background-color', false);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include roofsie_get_template('fancybox-one.php');
	}
}
