<?php

namespace Layerdrops\Roofsie\Widgets;


class ContactInfo extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'roofsie-contact-info';
	}

	public function get_title()
	{
		return __('Contact Info', 'roofsie-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['roofsie-category'];
	}

	protected function register_controls()
	{

		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'roofsie-addon'),
				]
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'content_section',
			[
				'label' => __('Content', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => 'layout_one'
				]
			]
		);


		$layout_one_item = new \Elementor\Repeater();

		$layout_one_item->add_control(
			'content',
			[
				'label' => __('Content Info', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' =>  wp_kses(__(' <a href="tel:9200368090" class="contact-details__number-1">+92 (003) 68-090</a>
				<a href="tel:6668888000" class="contact-details__number-2">+ 666 8888 000</a>'), 'roofsie_allowed_tags')
			]
		);


		$layout_one_item->add_control(
			'icon',
			[
				'label' => __('Icon', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-telephone',
					'library' => 'custom-icon',
				],
			]
		);

		$this->add_control(
			'contact_info_items',
			[
				'label' => __('Contact Info Items', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_one_item->get_controls(),
				'prevent_empty' => false,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_two_content_section',
			[
				'label' => __('Content', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => 'layout_two'
				]
			]
		);


		$layout_two_item = new \Elementor\Repeater();

		$layout_two_item->add_control(
			'icon',
			[
				'label' => __('Icon', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-phone-call',
					'library' => 'custom-icon',
				],
			]
		);

		$layout_two_item->add_control(
			'content',
			[
				'label' => __('Contact Info', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);

		$this->add_control(
			'layout_two_contact_info_items',
			[
				'label' => __('Contact Info Items', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_two_item->get_controls(),
				'prevent_empty' => false,
			]
		);


		$this->end_controls_section();

		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		roofsie_typo_and_color_options($this, 'Contact Info', '{{WRAPPER}} .contact-details__content h4, {{WRAPPER}} .contact-details__content h4 a', ['layout_one']);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include roofsie_get_template('contact-info-one.php');
	}
}
