<?php

namespace Layerdrops\Roofsie\Widgets;


class ContactForm extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'roofsie-contact-form';
    }

    public function get_title()
    {
        return __('Contact Form', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),
                    'layout_two' => __('Layout Two', 'roofsie-addon'),
                    'layout_three' => __('Layout Three', 'roofsie-addon'),
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_three']
                ]
            ]
        );

        $this->add_control(
            'layout_one_title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Title', 'roofsie-addon'),
                'default' => __('Contact for Services', 'roofsie-addon')
            ]
        );

        $this->add_control(
            'layout_one_sub_title',
            [
                'label' => __('Sub Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Sub Title', 'roofsie-addon'),
                'default' => __('Get a Free Estimate ', 'roofsie-addon')
            ]
        );

        $this->add_control(
            'layout_two_sub_title_image',
            [
                'label' => __('Sub Title Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
                'condition' => [
                    'layout_type' => ['layout_two', 'layout_three']
                ]
            ]
        );


        $this->add_control(
            'select_wpcf7_form',
            [
                'label'       => esc_html__('Select your contact form 7', 'roofsie-addon'),
                'label_block' => true,
                'type'        => \Elementor\Controls_Manager::SELECT,
                'options'     => roofsie_post_query('wpcf7_contact_form'),
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => __('Background Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two']
                ],
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .appointment__title,{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three']);
        roofsie_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .appointment__text,{{WRAPPER}} .section-sub-title', ['layout_one', 'layout_two', 'layout_three']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('contact-form-one.php');
        include roofsie_get_template('contact-form-two.php');
        include roofsie_get_template('contact-form-three.php');
    }
}
