<?php

namespace Layerdrops\Roofsie\Widgets;


class CallToAction extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'roofsie-call-to-action';
    }

    public function get_title()
    {
        return __('Call To Action', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Title', 'roofsie-addon'),
                'default' => __('Need roofing services? ', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __('Sub Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Sub Title', 'roofsie-addon'),
                'default' => __('QUALITY ROOFING PROVIDER', 'roofsie-addon'),
            ]
        );

        $this->add_control(
            'button_label',
            [
                'label' => __('Button Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('get free quote', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button_url',
            [
                'label' => __('Button Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => __('Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-arrow-right',
                    'library' => 'custom-icon',
                ],
            ]
        );


        $this->add_control(
            'background_image',
            [
                'label' => __('Background Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->add_control(
            'background_image_overlay_opacity',
            [
                'label' => __('Background Overlay Opacity', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cta-one' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Title', '{{WRAPPER}} .call-one__text, {{WRAPPER}} .cta-one__title', ['layout_one', 'layout_two']);
        roofsie_typo_and_color_options($this, 'Button', '{{WRAPPER}} .call-one__call-number a, {{WRAPPER}} .thm-btn.cta-one__btn-1', ['layout_one', 'layout_two']);
        roofsie_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} .call-one__call-number a, {{WRAPPER}} .thm-btn.cta-one__btn-1', ['layout_one', 'layout_two'], 'background-color', false);

        roofsie_typo_and_color_options($this, 'Button Two', '{{WRAPPER}} .thm-btn.cta-one__btn-2', ['layout_one', 'layout_two']);
        roofsie_typo_and_color_options($this, 'Button Two Background', '{{WRAPPER}} .thm-btn.cta-one__btn-2', ['layout_one', 'layout_two'], 'background-color', false);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('call-to-action-one.php');
    }
}
