<?php

namespace Layerdrops\Roofsie\Widgets;


class Button extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'roofsie-button';
    }

    public function get_title()
    {
        return __('Button', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two']
                ]
            ]
        );


        $this->add_control(
            'button_label',
            [
                'label' => __('Button Text', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Discover more', 'roofsie-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button_url',
            [
                'label' => __('Button Url', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'roofsie-addon'),
                'show_external' => true,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => __('Button Icon', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'placeholder' => __('Add Icon', 'roofsie-addon'),
                'default' => [
                    'value' => 'fa fa-angle-right',
                    'library' => 'custom-icon',
                ]
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Button', '{{WRAPPER}} .thm-btn.feature-three__btn, {{WRAPPER}} .thm-btn.service-details__btn', ['layout_one', 'layout_two']);
        roofsie_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} .thm-btn.feature-three__btn, {{WRAPPER}} .thm-btn.service-details__btn', ['layout_one', 'layout_two'], 'background-color', false);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('button-one.php');
    }
}
