<?php

namespace Layerdrops\Roofsie\Widgets;


class Blog extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'roofsie-blog';
    }

    public function get_title()
    {
        return __('Blog', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),
                    'layout_two' => __('Layout Two', 'roofsie-addon'),
                    'layout_three' => __('Layout Three', 'roofsie-addon'),
                    'layout_four' => __('Layout Four', 'roofsie-addon'),
                    'layout_five' => __('Layout Five', 'roofsie-addon'),
                ]
            ]
        );



        $this->add_control(
            'pagination_status',
            [
                'label' => __('Enable Pagination?', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'roofsie-addon'),
                'label_off' => __('No', 'roofsie-addon'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'layout_type!' =>  'layout_five'
                ]
            ]
        );


        $this->add_control(
            'sec_title',
            [
                'label' => __('Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Title', 'roofsie-addon'),
                'default' => __('Default Title', 'roofsie-addon'),
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_three']
                ]
            ]
        );

        $this->add_control(
            'sec_sub_title',
            [
                'label' => __('Sub Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Sub Title', 'roofsie-addon'),
                'default' => __('Default Sub Title', 'roofsie-addon'),
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_three']
                ]
            ]
        );

        $this->add_control(
            'sub_title_image',
            [
                'label' => __('Sub Title Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_three']
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Post Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'post_count',
            [
                'label' => __('Number Of Posts', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 0,
                        'max' => 15,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 6,
                ],
            ]
        );

        $this->add_control(
            'post_word_count',
            [
                'label' => __('Word Count In Excerpt', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 11,
                ],
            ]
        );

        $this->add_control(
            'select_category',
            [
                'label' => __('Post Category', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => roofsie_get_taxonoy('category'),
            ]
        );

        $this->add_control(
            'query_order',
            [
                'label' => __('Select Order', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'DESC',
                'options' => [
                    'DESC' => __('DESC', 'roofsie-addon'),
                    'ASC' => __('ASC', 'roofsie-addon'),
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'bg',
            [
                'label' => __('Background', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'layout_three'
                ]
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => __('Background Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three']);
        roofsie_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .section-sub-title', ['layout_one', 'layout_two', 'layout_three']);

        roofsie_typo_and_color_options($this, 'Title', '{{WRAPPER}} .blog-one__title a,{{WRAPPER}} .blog-two__title a', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        roofsie_typo_and_color_options($this, 'Content', '{{WRAPPER}} .blog-one__text, {{WRAPPER}} .blog-two__text', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        roofsie_typo_and_color_options($this, 'Date', '{{WRAPPER}} .blog-one__user-content h5', ['layout_one', 'layout_three', 'layout_four', 'layout_five'], 'color', false);
        roofsie_typo_and_color_options($this, 'Author', '{{WRAPPER}} .blog-one__user-content p', ['layout_one', 'layout_three', 'layout_four', 'layout_five']);
        roofsie_typo_and_color_options($this, 'Meta', '{{WRAPPER}} .blog-two__meta li a, {{WRAPPER}} .blog-two__meta li span', ['layout_two']);
        roofsie_typo_and_color_options($this, 'Read More', '{{WRAPPER}} .blog-one__read-more a,{{WRAPPER}} .blog-two__read-more a', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        roofsie_typo_and_color_options($this, 'Comment', '{{WRAPPER}} .blog-two__comment', ['layout_two']);

        $this->end_controls_section();

        roofsie_get_elementor_carousel_options($this, ['layout_five']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('blog-one.php');
        include roofsie_get_template('blog-two.php');
        include roofsie_get_template('blog-three.php');
        include roofsie_get_template('blog-four.php');
        include roofsie_get_template('blog-five.php');
    }
}
