<?php

namespace Layerdrops\Roofsie\Widgets;


class Award  extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'roofsie-award';
    }

    public function get_title()
    {
        return __('Award ', 'roofsie-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['roofsie-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'roofsie-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'sec_title',
            [
                'label' => __('Section Title', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Awesome Title', 'roofsie-addon'),
            ]
        );

        $award_images = new \Elementor\Repeater();

        $award_images->add_control(
            'image',
            [
                'label' => __('Add Image', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );


        $this->add_control(
            'award_images',
            [
                'label' => __('Award Items', 'roofsie-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $award_images->get_controls(),
                'prevent_empty' => false,
            ]
        );

        $this->end_controls_section();

        //General style
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('Style Options', 'roofsie-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        roofsie_typo_and_color_options($this, 'Title', '{{WRAPPER}} .awards__title', ['layout_one']);

        $this->end_controls_section();

        roofsie_get_elementor_carousel_options($this, ['layout_one']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include roofsie_get_template('award-one.php');
    }
}
