<?php

namespace Layerdrops\Roofsie\Widgets;


class About extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'roofsie-about';
	}

	public function get_title()
	{
		return __('About', 'roofsie-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['roofsie-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'roofsie-addon'),
					'layout_two' => __('Layout Two', 'roofsie-addon'),
					'layout_three' => __('Layout Three', 'roofsie-addon'),
					'layout_four' => __('Layout Four', 'roofsie-addon'),
					'layout_five' => __('Layout Five', 'roofsie-addon'),
					'layout_six' => __('Layout Six', 'roofsie-addon'),
					'layout_seven' => __('Layout Seven', 'roofsie-addon'),
				]
			]
		);

		$this->end_controls_section();

		//layout_one
		$this->start_controls_section(
			'layout_one_content',
			[
				'label' => __('Content', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'conditions' => [
					'terms' => [
						[
							'name' => 'layout_type',
							'operator' => '==',
							'value' => 'layout_one'
						]
					]
				]
			]
		);

		$this->add_control(
			'layout_one_sec_title',
			[
				'label' => __('Section Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add title', 'roofsie-addon'),
				'default' =>  __('Default Title', 'roofsie-addon'),
			]
		);

		$this->add_control(
			'layout_one_sec_sub_title',
			[
				'label' => __('Section Sub Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Sub title', 'roofsie-addon'),
				'default' =>  __('Default Sub Title', 'roofsie-addon'),
			]
		);

		$this->add_control(
			'layout_one_sub_title_image',
			[
				'label' => __('Sub Title Image', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'layout_one_summary',
			[
				'label' => __('Summary', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Summary', 'roofsie-addon'),
				'default' =>  __('Default Summary Text', 'roofsie-addon'),
			]
		);

		$layout_one_features = new \Elementor\Repeater();

		$layout_one_features->add_control(
			'title',
			[
				'label' => __('Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Innovative work', 'roofsie-addon'),
				'label_block' => true
			]
		);

		$layout_one_features->add_control(
			'summary',
			[
				'label' => __('Summary', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __('Default Summary', 'roofsie-addon')
			]
		);

		$layout_one_features->add_control(
			'icon',
			[
				'label' => __('Icon', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-confirmation',
					'library' => 'custom-icon',
				],
			]
		);

		$this->add_control(
			'layout_one_features',
			[
				'label' => __('Feature List', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $layout_one_features->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->add_control(
			'layout_one_button_label',
			[
				'label' => __('Button Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Discover more', 'roofsie-addon'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'layout_one_button_url',
			[
				'label' => __('Button Url', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'roofsie-addon'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
				'show_label' => false,
			]
		);

		$this->add_control(
			'big_text',
			[
				'label' => __('Big Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('roofing', 'roofsie-addon'),
				'label_block' => true,
			]
		);

		$this->end_controls_section();

		//layout_one_image
		$this->start_controls_section(
			'section_image_one',
			[
				'label' => __('Image', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'conditions' => [
					'terms' => [
						[
							'name' => 'layout_type',
							'operator' => '==',
							'value' => 'layout_one'
						]
					]
				]
			]
		);


		$this->add_control(
			'layout_one_image',
			[
				'label' => __('Image', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);


		$this->add_control(
			'layout_one_image_bg',
			[
				'label' => __('Image Background', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'layout_one_section_bg',
			[
				'label' => __('Section Background', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'layout_one_image_count',
			[
				'label' => __('Count Number', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('98', 'roofsie-addon'),
				'label_block' => true,
			]
		);


		$this->add_control(
			'layout_one_image_caption_text',
			[
				'label' => __('Caption Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Satisfied customers', 'roofsie-addon'),
				'label_block' => true,
			]
		);


		$this->add_control(
			'layout_one_caption_bg',
			[
				'label' => __('Caption Background', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_two_content',
			[
				'label' => __('Content', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'conditions' => [
					'terms' => [
						[
							'name' => 'layout_type',
							'operator' => '==',
							'value' => 'layout_two'
						]
					]
				]
			]
		);

		$this->add_control(
			'layout_two_sec_title',
			[
				'label' => __('Section Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add title', 'roofsie-addon'),
				'default' => __('We’re Cleaning for you Since 1987', 'roofsie-addon')
			]
		);

		$this->add_control(
			'layout_two_sec_sub_title',
			[
				'label' => __('Section Sub Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Sub title', 'roofsie-addon'),
				'default' => __('Best Experts in Cleaning', 'roofsie-addon')
			]
		);

		$this->add_control(
			'layout_two_sub_title_image',
			[
				'label' => __('Sub Title Image', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'layout_two_summary',
			[
				'label' => __('Summary', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Summary', 'roofsie-addon'),
				'default' => __('Default Summary Text', 'roofsie-addon')
			]
		);

		$layout_two_feature_list = new \Elementor\Repeater();


		$layout_two_feature_list->add_control(
			'title',
			[
				'label' => __('Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Features Title', 'roofsie-addon'),
				'default' =>  wp_kses(__('Quality <br> materials', 'roofsie-addon'), 'roofsie_allowed_tags')
			]
		);

		$layout_two_feature_list->add_control(
			'icon',
			[
				'label' => __('Icon', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-roof-2',
					'library' => 'custom-icon',
				],
			]
		);

		$this->add_control(
			'layout_two_feature_list',
			[
				'label' => __('Features', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_two_feature_list->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'section_image_two',
			[
				'label' => __('Image', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'conditions' => [
					'terms' => [
						[
							'name' => 'layout_type',
							'operator' => '==',
							'value' => 'layout_two'
						]
					]
				]
			]
		);


		$this->add_control(
			'layout_two_image',
			[
				'label' => __('Image', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'layout_two_name',
			[
				'label' => __('Name', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __('Add Name', 'roofsie-addon'),
				'default' => __('Kevin Martin', 'roofsie-addon')
			]
		);

		$this->add_control(
			'layout_two_shape_one',
			[
				'label' => __('Shape One', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);


		$this->add_control(
			'layout_two_shape_two',
			[
				'label' => __('Shape Two', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'layout_three_content',
			[
				'label' => __('Content', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'conditions' => [
					'terms' => [
						[
							'name' => 'layout_type',
							'operator' => '==',
							'value' => 'layout_three'
						]
					]
				]
			]
		);

		$this->add_control(
			'layout_three_sec_title',
			[
				'label' => __('Section Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add title', 'roofsie-addon'),
				'default' => __('Default Title', 'roofsie-addon')
			]
		);

		$this->add_control(
			'layout_three_sec_sub_title',
			[
				'label' => __('Section Sub Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Sub title', 'roofsie-addon'),
				'default' => __('Default Sub Title', 'roofsie-addon')
			]
		);

		$this->add_control(
			'layout_three_sub_title_image',
			[
				'label' => __('Sub Title Image', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'layout_three_highlighted_text',
			[
				'label' => __('Highlighted Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Highlighted Text', 'roofsie-addon'),
				'default' => __('Default Highlighted Text', 'roofsie-addon')
			]
		);

		$this->add_control(
			'layout_three_summary',
			[
				'label' => __('Summary Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Summary Text', 'roofsie-addon'),
				'default' => __('Default Summary Text', 'roofsie-addon')
			]
		);

		$layout_three_feature_list = new \Elementor\Repeater();

		$layout_three_feature_list->add_control(
			'title',
			[
				'label' => __('Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __('Add Feature Title', 'roofsie-addon'),
				'default' => __('Default Title', 'roofsie-addon')
			]
		);

		$layout_three_feature_list->add_control(
			'content',
			[
				'label' => __('Content', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Check List Text', 'roofsie-addon'),
				'default' => __('Default Content', 'roofsie-addon')
			]
		);

		$layout_three_feature_list->add_control(
			'icon',
			[
				'label' => __('Icon', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-award',
					'library' => 'custom-icon',
				],
			]
		);

		$this->add_control(
			'layout_three_feature_list',
			[
				'label' => __('Features', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $layout_three_feature_list->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->add_control(
			'layout_three_button_label',
			[
				'label' => __('Button Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Discover More', 'roofsie-addon'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'layout_three_button_url',
			[
				'label' => __('Button Url', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'roofsie-addon'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
				'show_label' => false,
			]
		);

		$this->end_controls_section(); //end layout_three_content

		//layout_three_image
		$this->start_controls_section(
			'section_image_three',
			[
				'label' => __('Image', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'conditions' => [
					'terms' => [
						[
							'name' => 'layout_type',
							'operator' => '==',
							'value' => 'layout_three'
						]
					]
				]
			]
		);

		$this->add_control(
			'layout_three_image_one',
			[
				'label' => __('Image One', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);


		$this->add_control(
			'layout_three_image_two',
			[
				'label' => __('Image Two', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'layout_three_image_shape',
			[
				'label' => __('Image Shape', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'layout_three_caption_count',
			[
				'label' => __('Caption Count Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '20',
				'label_block' => true,
			]
		);

		$this->add_control(
			'layout_three_caption_text',
			[
				'label' => __('Caption Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => wp_kses(__('Years of <br> practicing', 'roofsie-addon'), 'roofsie_allowed_tags'),
				'label_block' => true,
			]
		);


		$this->add_control(
			'layout_three_image_caption_image',
			[
				'label' => __('Image Caption Image', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->end_controls_section(); //end layout_three_image

		//layout_four
		$this->start_controls_section(
			'layout_four_content',
			[
				'label' => __('Content', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'conditions' => [
					'terms' => [
						[
							'name' => 'layout_type',
							'operator' => '==',
							'value' => 'layout_four'
						]
					]
				]
			]
		);

		$this->add_control(
			'layout_four_sec_title',
			[
				'label' => __('Section Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add title', 'roofsie-addon'),
				'default' => __('See Why You Should Choose Roofsie', 'roofsie-addon')
			]
		);

		$this->add_control(
			'layout_four_sec_sub_title',
			[
				'label' => __('Section Sub Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Sub title', 'roofsie-addon'),
				'default' => __('Company Benefits', 'roofsie-addon')
			]
		);

		$this->add_control(
			'layout_four_sub_title_image',
			[
				'label' => __('Sub Title Image', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$layout_four_Left_features = new \Elementor\Repeater();

		$layout_four_Left_features->add_control(
			'title',
			[
				'label' => __('Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __('Features Title', 'roofsie-addon'),
				'default' => __('Quality material', 'roofsie-addon'),
				'label_block' => true
			]
		);

		$layout_four_Left_features->add_control(
			'summary',
			[
				'label' => __('Summary', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Features Summary', 'roofsie-addon'),
				'default' => __('Default Summary Text', 'roofsie-addon'),
				'label_block' => true
			]
		);

		$layout_four_Left_features->add_control(
			'icon',
			[
				'label' => __('Check Icon', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-roof-2',
					'library' => 'custom-icon',
				],
			]
		);

		$layout_four_Left_features->add_control(
			'button_label',
			[
				'label' => __('Button Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Read More ', 'roofsie-addon'),
				'label_block' => true,
			]
		);

		$layout_four_Left_features->add_control(
			'button_url',
			[
				'label' => __('Button Url', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'roofsie-addon'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
				'show_label' => false,
			]
		);

		$this->add_control(
			'layout_four_Left_features',
			[
				'label' => __('Left Side Features', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_four_Left_features->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
			]
		);


		$layout_four_Right_features = new \Elementor\Repeater();

		$layout_four_Right_features->add_control(
			'title',
			[
				'label' => __('Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __('Features Title', 'roofsie-addon'),
				'default' => __('Fully insured', 'roofsie-addon'),
				'label_block' => true
			]
		);

		$layout_four_Right_features->add_control(
			'summary',
			[
				'label' => __('Summary', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Features Summary', 'roofsie-addon'),
				'default' => __('Default Summary Text', 'roofsie-addon'),
				'label_block' => true
			]
		);

		$layout_four_Right_features->add_control(
			'icon',
			[
				'label' => __('Check Icon', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-shield',
					'library' => 'custom-icon',
				],
			]
		);

		$layout_four_Right_features->add_control(
			'button_label',
			[
				'label' => __('Button Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Read More ', 'roofsie-addon'),
				'label_block' => true,
			]
		);

		$layout_four_Right_features->add_control(
			'button_url',
			[
				'label' => __('Button Url', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'roofsie-addon'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
				'show_label' => false,
			]
		);

		$this->add_control(
			'layout_four_Right_features',
			[
				'label' => __('Right Side Features', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_four_Right_features->get_controls(),
				'prevent_empty' => false,
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section(); //end layout_four_content


		//layout_four_image
		$this->start_controls_section(
			'section_image_four',
			[
				'label' => __('Image', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'conditions' => [
					'terms' => [
						[
							'name' => 'layout_type',
							'operator' => '==',
							'value' => 'layout_four'
						]
					]
				]
			]
		);


		$this->add_control(
			'layout_four_image',
			[
				'label' => __('Image', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'layout_four_image_shape',
			[
				'label' => __('Image Shape', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'layout_four_bg_image',
			[
				'label' => __('Background Image', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);


		$this->end_controls_section(); //end layout_three_image

		//layout_five
		$this->start_controls_section(
			'layout_five_content',
			[
				'label' => __('Content', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'conditions' => [
					'terms' => [
						[
							'name' => 'layout_type',
							'operator' => '==',
							'value' => 'layout_five'
						]
					]
				]
			]
		);

		$this->add_control(
			'layout_five_sec_title',
			[
				'label' => __('Section Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add title', 'roofsie-addon'),
				'default' => __('See Why You Should Choose Roofsie', 'roofsie-addon')
			]
		);

		$this->add_control(
			'layout_five_sec_sub_title',
			[
				'label' => __('Section Sub Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Sub title', 'roofsie-addon'),
				'default' => __('Company Benefits', 'roofsie-addon')
			]
		);

		$this->add_control(
			'layout_five_sub_title_image',
			[
				'label' => __('Sub Title Image', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'layout_five_summary',
			[
				'label' => __('Summary Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Summary Text', 'roofsie-addon'),
				'default' => __('Default Summary Text', 'roofsie-addon')
			]
		);

		$layout_five_check_list = new \Elementor\Repeater();

		$layout_five_check_list->add_control(
			'title',
			[
				'label' => __('Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __('Add Check List Text', 'roofsie-addon'),
				'default' => __('Exploring version oflorem veritatis proin', 'roofsie-addon'),
				'label_block' => true
			]
		);

		$layout_five_check_list->add_control(
			'icon',
			[
				'label' => __('Check Icon', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa fa-check',
					'library' => 'custom-icon',
				],
			]
		);

		$this->add_control(
			'layout_five_check_list',
			[
				'label' => __('Check Lists', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $layout_five_check_list->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->add_control(
			'layout_five_button_label',
			[
				'label' => __('Button Label', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Discover more', 'roofsie-addon'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'layout_five_button_url',
			[
				'label' => __('Button Url', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'roofsie-addon'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
				'show_label' => false,
			]
		);

		$this->add_control(
			'layout_five_icon',
			[
				'label' => __('Button Icon', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa fa-arrow-right',
					'library' => 'custom-icon',
				],
			]
		);

		$this->end_controls_section(); //end layout_five_content

		//layout_five_image
		$this->start_controls_section(
			'section_image_five',
			[
				'label' => __('Image', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'conditions' => [
					'terms' => [
						[
							'name' => 'layout_type',
							'operator' => '==',
							'value' => 'layout_five'
						]
					]
				]
			]
		);


		$this->add_control(
			'layout_five_image_one',
			[
				'label' => __('Image One', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'layout_five_image_two',
			[
				'label' => __('Image Two', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'layout_five_shape_one',
			[
				'label' => __('Shape One', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);


		$this->add_control(
			'layout_five_shape_two',
			[
				'label' => __('Shape Two', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->end_controls_section(); //end layout_five_image

		//layout_six
		$this->start_controls_section(
			'layout_six_content',
			[
				'label' => __('Content', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'conditions' => [
					'terms' => [
						[
							'name' => 'layout_type',
							'operator' => '==',
							'value' => 'layout_six'
						]
					]
				]
			]
		);

		$layout_features_list = new \Elementor\Repeater();

		$layout_features_list->add_control(
			'title',
			[
				'label' => __('Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Reliable & trustworthy', 'roofsie-addon'),
				'label_block' => true
			]
		);

		$layout_features_list->add_control(
			'content',
			[
				'label' => __('Content', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __('Default Content', 'roofsie-addon'),
				'label_block' => true
			]
		);

		$layout_features_list->add_control(
			'icon',
			[
				'label' => __('Icon', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-tick',
					'library' => 'custom-icon',
				],
			]
		);

		$this->add_control(
			'layout_features_list',
			[
				'label' => __('Features Lists', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $layout_features_list->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$layout_six_faq = new \Elementor\Repeater();


		$layout_six_faq->add_control(
			'question',
			[
				'label' => __('Question', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __('Add Question', 'roofsie-addon'),
				'label_block' => true,
				'default' => __('Default Question', 'roofsie-addon')
			]
		);
		$layout_six_faq->add_control(
			'answer',
			[
				'label' => __('Answer', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Answer', 'roofsie-addon'),
				'label_block' => true,
				'default' => __('Default Answer', 'roofsie-addon')
			]
		);

		$layout_six_faq->add_control(
			'active_status',
			[
				'label' => __('Is active?', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'roofsie-addon'),
				'label_off' => __('No', 'roofsie-addon'),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'layout_six_faq_lists',
			[
				'label' => __('FAQ', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $layout_six_faq->get_controls(),
				'title_field' => '{{{ question }}}',
			]
		);

		$this->add_control(
			'layout_six_image',
			[
				'label' => __('Image', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->end_controls_section(); //end layout_six_content


		//layout_seven
		$this->start_controls_section(
			'layout_seven_content',
			[
				'label' => __('Content', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'conditions' => [
					'terms' => [
						[
							'name' => 'layout_type',
							'operator' => '==',
							'value' => 'layout_seven'
						]
					]
				]
			]
		);

		$this->add_control(
			'layout_seven_sec_title',
			[
				'label' => __('Section Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add title', 'roofsie-addon'),
				'default' => __('See Why You Should Choose Roofsie', 'roofsie-addon')
			]
		);

		$this->add_control(
			'layout_seven_sec_sub_title',
			[
				'label' => __('Section Sub Title', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Sub title', 'roofsie-addon'),
				'default' => __('Company Benefits', 'roofsie-addon')
			]
		);

		$this->add_control(
			'layout_seven_sub_title_image',
			[
				'label' => __('Sub Title Image', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'layout_seven_summary',
			[
				'label' => __('Summary Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => __('Add Summary Text', 'roofsie-addon'),
				'default' => __('Default Summary Text', 'roofsie-addon')
			]
		);

		$layout_seven_check_list = new \Elementor\Repeater();

		$layout_seven_check_list->add_control(
			'title',
			[
				'label' => __('Text', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => __('Add Check List Text', 'roofsie-addon'),
				'default' => __('Exploring version oflorem veritatis proin', 'roofsie-addon'),
				'label_block' => true
			]
		);

		$layout_seven_check_list->add_control(
			'icon',
			[
				'label' => __('Check Icon', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa fa-check',
					'library' => 'custom-icon',
				],
			]
		);

		$this->add_control(
			'layout_seven_check_list',
			[
				'label' => __('Check Lists', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $layout_seven_check_list->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->add_control(
			'layout_seven_button_label',
			[
				'label' => __('Button Label', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Discover more', 'roofsie-addon'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'layout_seven_button_url',
			[
				'label' => __('Button Url', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'roofsie-addon'),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
				'show_label' => false,
			]
		);

		$this->add_control(
			'layout_seven_icon',
			[
				'label' => __('Button Icon', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa fa-arrow-right',
					'library' => 'custom-icon',
				],
			]
		);

		$this->end_controls_section(); //end layout_seven_content

		//layout_seven_image
		$this->start_controls_section(
			'section_image_seven',
			[
				'label' => __('Image', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'conditions' => [
					'terms' => [
						[
							'name' => 'layout_type',
							'operator' => '==',
							'value' => 'layout_seven'
						]
					]
				]
			]
		);


		$this->add_control(
			'layout_seven_image_one',
			[
				'label' => __('Image One', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'layout_seven_image_two',
			[
				'label' => __('Image Two', 'roofsie-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->end_controls_section(); //end layout_seven_image


		//General style
		$this->start_controls_section(
			'general_style',
			[
				'label' => esc_html__('Style Options', 'roofsie-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		roofsie_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_seven']);
		roofsie_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .section-sub-title', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five', 'layout_seven']);

		roofsie_typo_and_color_options($this, 'Highlighted Text', '{{WRAPPER}} .about-two__text-1', ['layout_three']);
		roofsie_typo_and_color_options($this, 'Summary Text', '{{WRAPPER}} .about-one__text, {{WRAPPER}} .why-choose-one__text, {{WRAPPER}} .about-two__text-2, {{WRAPPER}} .about-three__text', ['layout_one', 'layout_two', 'layout_three', 'layout_five']);


		roofsie_typo_and_color_options($this, 'Features Title', '{{WRAPPER}} .about-one__points li .icon-box .text-box p, {{WRAPPER}} .why-choose-one__points-title,{{WRAPPER}} .about-two__points li .text h4,{{WRAPPER}} .content h4', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_six']);
		roofsie_typo_and_color_options($this, 'Features Content', '{{WRAPPER}} .text-box-two, {{WRAPPER}} .about-one__points li .icon-box .text-box-two p, {{WRAPPER}} .text p,{{WRAPPER}} .content p', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_six']);
		roofsie_typo_and_color_options($this, 'Features Button Label', '{{WRAPPER}} .why-choose-two__read-more a', ['layout_four']);

		roofsie_typo_and_color_options($this, 'Check List Title', '{{WRAPPER}} .about-three__point li .text p', ['layout_five',  'layout_seven']);

		roofsie_typo_and_color_options($this, 'Faq Question', '{{WRAPPER}} .faq-one-accrodion .accrodion-title h4', ['layout_six']);
		roofsie_typo_and_color_options($this, 'Faq Answer', '{{WRAPPER}} .faq-one-accrodion .accrodion-content p', ['layout_six']);


		roofsie_typo_and_color_options($this, 'Button', '{{WRAPPER}} .thm-btn', ['layout_one', 'layout_three', 'layout_five', 'layout_seven']);
		roofsie_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} .thm-btn', ['layout_one', 'layout_three', 'layout_five', 'layout_seven'], 'background-color', false);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include roofsie_get_template('about-one.php');
		include roofsie_get_template('about-two.php');
		include roofsie_get_template('about-three.php');
		include roofsie_get_template('about-four.php');
		include roofsie_get_template('about-five.php');
		include roofsie_get_template('about-six.php');
		include roofsie_get_template('about-seven.php');
	}
}
