<?php

namespace Layerdrops\Roofsie;

class Utility
{
    public function __construct()
    {
        $this->register_image_size();
        add_filter('single_template', [$this, 'load_portfolio_template']);
        add_filter('single_template', [$this, 'load_service_template']);
    }
    public function register_image_size()
    {
        add_image_size('roofsie_blog_370X245', 370, 245, true); // in use
        // add_image_size('roofsie_blog_270X220', 270, 220, true); // in use
        // add_image_size('roofsie_blog_80X80', 80, 80, true); // in use
        // add_image_size('roofsie_portfolio_1170X472', 1170, 472, true); // in use
        // add_image_size('roofsie_portfolio_370X472', 370, 472, true); // in use
        // add_image_size('roofsie_portfolio_370X372', 370, 372, true); // in use
    }

    public function load_portfolio_template($template)
    {
        global $post;

        if ('portfolio' === $post->post_type && locate_template(array('single-portfolio.php')) !== $template) {
            /*
            * This is a 'portfolio' post
            * AND a 'single portfolio template' is not found on
            * theme or child theme directories, so load it
            * from our plugin directory.
            */
            return ROOFSIE_ADDON_PATH . '/post-templates/single-portfolio.php';
        }

        return $template;
    }

    public function load_service_template($template)
    {
        global $post;

        if ('service' === $post->post_type && locate_template(array('single-service.php')) !== $template) {
            /*
            * This is a 'service' post
            * AND a 'single service template' is not found on
            * theme or child theme directories, so load it
            * from our plugin directory.
            */
            return ROOFSIE_ADDON_PATH . '/post-templates/single-service.php';
        }

        return $template;
    }
}
