<?php

namespace Layerdrops\Roofsie\Metaboxes;


class Page
{
    function __construct()
    {
        add_action('cmb2_admin_init', [$this, 'page_metabox']);
    }

    function page_metabox()
    {
        $prefix = 'roofsie_';

        $general = new_cmb2_box(array(
            'id'           => $prefix . 'page_option',
            'title'        => __('General Options', 'roofsie-addon'),
            'object_types' => array('page'),
            'context'      => 'normal',
            'priority'     => 'default',
        ));

        $general->add_field(array(
            'name' => __('Enable Custom Header', 'roofsie-addon'),
            'id' => $prefix . 'custom_header_status',
            'type' => 'radio',
            'options' => array(
                'on' => __('On', 'roofsie-addon'),
                'off'   => __('Off', 'roofsie-addon'),
            ),
        ));


        $general->add_field(array(
            'name' => __('Select Custom Header', 'roofsie-addon'),
            'id' => $prefix . 'select_custom_header',
            'type' => 'pw_select',
            'options' => roofsie_post_query('header'),
            'attributes' => array(
                'data-conditional-id' => $prefix . 'custom_header_status',
                'data-conditional-value' => 'on',
            ),
        ));

        $general->add_field(array(
            'name' => __('Enable Custom Footer', 'roofsie-addon'),
            'id' => $prefix . 'custom_footer_status',
            'type' => 'radio',
            'options' => array(
                'on' => __('On', 'roofsie-addon'),
                'off'   => __('Off', 'roofsie-addon'),
            ),
        ));


        $general->add_field(array(
            'name' => __('Select Custom Footer', 'roofsie-addon'),
            'id' => $prefix . 'select_custom_footer',
            'type' => 'pw_select',
            'options' => roofsie_post_query('footer'),
            'attributes' => array(
                'data-conditional-id' => $prefix . 'custom_footer_status',
                'data-conditional-value' => 'on',
            ),
        ));


        $general->add_field(array(
            'name' => __('Show Page Banner', 'roofsie-addon'),
            'id' => $prefix . 'show_page_banner',
            'type' => 'radio',
            'default' => 'on',
            'options' => array(
                'on' => __('On', 'roofsie-addon'),
                'off' => __('Off', 'roofsie-addon'),
            ),
        ));

        $general->add_field(array(
            'name' => __('Enable BreadCrumb', 'roofsie-addon'),
            'id' => $prefix . 'show_page_breadcrumb',
            'type' => 'radio',
            'default' => 'on',
            'options' => array(
                'on' => __('On', 'roofsie-addon'),
                'off' => __('Off', 'roofsie-addon'),
            ),
            'attributes' => array(
                'data-conditional-id' => $prefix . 'show_page_banner',
                'data-conditional-value' => 'on',
            ),
        ));

        $general->add_field(array(
            'name' => __('Header Title', 'roofsie-addon'),
            'id' => $prefix . 'set_header_title',
            'type' => 'text',
            'attributes' => array(
                'data-conditional-id' => $prefix . 'show_page_banner',
                'data-conditional-value' => 'on',
            ),
        ));

        $general->add_field(array(
            'name' => __('Header Image', 'roofsie-addon'),
            'id' => $prefix . 'set_header_image',
            'type' => 'file',
            'attributes' => array(
                'data-conditional-id' => $prefix . 'show_page_banner',
                'data-conditional-value' => 'on',
            ),
        ));


        $general->add_field(array(
            'name' => __('Enable Dark Mode', 'roofsie-addon'),
            'id' => $prefix . 'enable_dark_mode',
            'type' => 'radio',
            'default' => 'no',
            'options' => array(
                'yes' => __('On', 'roofsie-addon'),
                'no' => __('Off', 'roofsie-addon'),
            ),
        ));

        $general->add_field(array(
            'name' => __('Enable Boxed Mode', 'roofsie-addon'),
            'id' => $prefix . 'enable_boxed_mode',
            'type' => 'radio',
            'default' => 'no',
            'options' => array(
                'yes' => __('On', 'roofsie-addon'),
                'no' => __('Off', 'roofsie-addon'),
            ),
        ));


        $color_options = new_cmb2_box(array(
            'id'           => $prefix . 'page_color_option',
            'title'        => __('Color Options', 'roofsie-addon'),
            'object_types' => array('page'),
            'context'      => 'normal',
            'priority'     => 'default',
        ));


        $color_options->add_field(array(
            'name' => __('Base Color', 'roofsie-addon'),
            'id' => $prefix . 'base_color',
            'type'    => 'colorpicker',
        ));
        $color_options->add_field(array(
            'name' => __('black Color', 'roofsie-addon'),
            'id' => $prefix . 'black_color',
            'type'    => 'colorpicker',
        ));
    }
}
