<?php

namespace Layerdrops\Roofsie;

class Customizer
{
    public function __construct()
    {
        add_action("customize_register", [$this, 'roofsie_customizer']);
    }
    public function roofsie_customizer($wp_customize)
    {

        // add panel
        $wp_customize->add_panel(
            'roofsie_theme_opt',
            array(
                'title'      => esc_html__('Roofsie Options', 'roofsie-addon'),
                'description' => esc_html__('Roofsie Theme options panel', 'roofsie-addon'),
                'priority'   => 220,
                'capability' => 'edit_theme_options',
            )
        );

        // General Settings
        $wp_customize->add_section('roofsie_theme_general', array(
            'title' => __('General Settings', 'roofsie-addon'),
            'description' => esc_html__('Roofsie General Settings.', 'roofsie-addon'),
            'priority' => 10,
            'capability' => 'edit_theme_options',
            'panel'      => 'roofsie_theme_opt'
        ));


        $this->customize_type_color(
            $wp_customize,
            esc_html__('Select Theme Base color', 'roofsie-addon'),
            'roofsie_theme_general',
            'theme_base_color',
            '#ff4f47'
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Dark Mode?', 'roofsie-addon'),
            'roofsie_theme_general',
            'roofsie_dark_mode',
            'no',
            array(
                'yes' => esc_html__('Yes', 'roofsie-addon'),
                'no' => esc_html__('No', 'roofsie-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Boxed Mode?', 'roofsie-addon'),
            'roofsie_theme_general',
            'roofsie_boxed_mode',
            'no',
            array(
                'yes' => esc_html__('Yes', 'roofsie-addon'),
                'no' => esc_html__('No', 'roofsie-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Custom Cursor', 'roofsie-addon'),
            'roofsie_theme_general',
            'custom_cursor',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'roofsie-addon'),
                'no' => esc_html__('No', 'roofsie-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Back to top?', 'roofsie-addon'),
            'roofsie_theme_general',
            'scroll_to_top',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'roofsie-addon'),
                'no' => esc_html__('No', 'roofsie-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select Back to top icon', 'roofsie-addon'),
            'roofsie_theme_general',
            'scroll_to_top_icon',
            'fa-angle-up',
            roofsie_get_fa_icons(),
            function () {
                return (get_theme_mod('scroll_to_top', 'no') == 'yes' ? true : false);
            }
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Preloader?', 'roofsie-addon'),
            'roofsie_theme_general',
            'preloader',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'roofsie-addon'),
                'no' => esc_html__('No', 'roofsie-addon'),
            )
        );

        $this->customize_type_image(
            $wp_customize,
            esc_html__('Custom Preloader Image', 'roofsie-addon'),
            'roofsie_theme_general',
            'preloader_image',
            '',
            function () {
                return (get_theme_mod('preloader', 'no') == 'yes' ? true : false);
            }
        );

        $this->customize_type_image(
            $wp_customize,
            esc_html__('Page Header Background Image', 'roofsie-addon'),
            'roofsie_theme_general',
            'page_header_bg_image'
        );


        // Blog Layout
        $wp_customize->add_section('roofsie_blog_layout_settings', array(
            'title' => __('Blog Layout', 'roofsie-addon'),
            'description' => esc_html__('Roofsie Blog Layout', 'roofsie-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'roofsie_theme_opt'
        ));

        $this->customize_type_select(
            $wp_customize,
            'Select Sidebar position',
            'roofsie_blog_layout_settings',
            'roofsie_blog_layout',
            'right-align',
            array(
                'left-align' => esc_html__('Left Align', 'roofsie-addon'),
                'right-align' => esc_html__('Right Align', 'roofsie-addon'),
            )
        );

        // Header options
        $wp_customize->add_section('roofsie_theme_header', array(
            'title' => __('Header Settings', 'roofsie-addon'),
            'description' => esc_html__('Roofsie Header Settings', 'roofsie-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'roofsie_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Add Logo size in px', 'roofsie-addon'),
            'roofsie_theme_header',
            'header_logo_width',
            esc_html(198)
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Sticky Header?', 'roofsie-addon'),
            'roofsie_theme_header',
            'header_sticky_menu',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'roofsie-addon'),
                'no' => esc_html__('No', 'roofsie-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__(' Enable Breadcrumb?', 'roofsie-addon'),
            'roofsie_theme_header',
            'breadcrumb_opt',
            'yes',
            array(
                'yes' => esc_html__('Yes', 'roofsie-addon'),
                'no' => esc_html__('No', 'roofsie-addon'),
            )
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Custom Header?', 'roofsie-addon'),
            'roofsie_theme_header',
            'header_custom',
            'no',
            array(
                'yes' => esc_html__('Yes', 'roofsie-addon'),
                'no' => esc_html__('No', 'roofsie-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select Header Type', 'roofsie-addon'),
            'roofsie_theme_header',
            'header_custom_post',
            '',
            roofsie_post_query('header'),
            function () {
                return (get_theme_mod('header_custom', 'no') == 'yes' ? true : false);
            }
        );

        //  Mobile Menu
        $wp_customize->add_section('roofsie_theme_mobile_menu', array(
            'title' => esc_html__('Mobile Menu Settings', 'roofsie-addon'),
            'description' => esc_html__('Roofsie Header Settings', 'roofsie-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'roofsie_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Mobile Menu Email', 'roofsie-addon'),
            'roofsie_theme_mobile_menu',
            'roofsie_mobile_menu_email',
            esc_html__('needhelp@roofsie.com', 'roofsie-addon')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Mobile Menu Phone', 'roofsie-addon'),
            'roofsie_theme_mobile_menu',
            'roofsie_mobile_menu_phone',
            esc_html__('666 888 0000', 'roofsie-addon')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Facebook url', 'roofsie-addon'),
            'roofsie_theme_mobile_menu',
            'facebook_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Twitter url', 'roofsie-addon'),
            'roofsie_theme_mobile_menu',
            'twitter_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Linkedin url', 'roofsie-addon'),
            'roofsie_theme_mobile_menu',
            'linkedin_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Pinterest url', 'roofsie-addon'),
            'roofsie_theme_mobile_menu',
            'pinterest_url',
            esc_html('#')
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Youtube url', 'roofsie-addon'),
            'roofsie_theme_mobile_menu',
            'youtube_url',
        );


        $this->customize_type_text(
            $wp_customize,
            esc_html__('dribbble url', 'roofsie-addon'),
            'roofsie_theme_mobile_menu',
            'dribble_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Instagram url', 'roofsie-addon'),
            'roofsie_theme_mobile_menu',
            'instagram_url',
        );

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Reddit url', 'roofsie-addon'),
            'roofsie_theme_mobile_menu',
            'reddit_url',
        );

        // Footer options
        $wp_customize->add_section('roofsie_theme_footer', array(
            'title' => esc_html__('Footer Settings', 'roofsie-addon'),
            'description' => esc_html__('Roofsie Footer Settings.', 'roofsie-addon'),
            'priority' => 20,
            'capability' => 'edit_theme_options',
            'panel'      => 'roofsie_theme_opt'
        ));

        $this->customize_type_text(
            $wp_customize,
            esc_html__('Footer Text', 'roofsie-addon'),
            'roofsie_theme_footer',
            'footer_copytext',
            esc_html__('&copy; All right reserved', 'roofsie'),
            function () {
                return (get_theme_mod('footer_custom', 'no') == 'yes' ? false : true);
            }
        );

        $this->customize_type_radio(
            $wp_customize,
            esc_html__('Enable Custom Footer ?', 'roofsie-addon'),
            'roofsie_theme_footer',
            'footer_custom',
            'no',
            array(
                'yes' => esc_html__('Yes', 'roofsie-addon'),
                'no' => esc_html__('No', 'roofsie-addon'),
            )
        );

        $this->customize_type_select(
            $wp_customize,
            esc_html__('Select Footer Type', 'roofsie-addon'),
            'roofsie_theme_footer',
            'footer_custom_post',
            '',
            roofsie_post_query('footer'),
            function () {
                return (get_theme_mod('footer_custom', 'no') == 'yes' ? true : false);
            }
        );
    }

    //type text
    public function customize_type_text($wp_customize, $label, $section_id, $name,  $default = "", $callback = null)
    {
        // add settings
        $wp_customize->add_setting($name, array(
            'default'  => $default,
            'type'     => 'theme_mod'
        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "text",
                "active_callback" => $callback,
            )
        ));
    }


    //type color
    public function customize_type_color($wp_customize, $label, $section_id, $name,  $default)
    {
        // add settings
        $wp_customize->add_setting($name, array(
            'default'  => sanitize_hex_color($default),
            'type'     => 'theme_mod'
        ));

        // Add control
        $wp_customize->add_control(new \WP_Customize_Color_Control($wp_customize, $name, array(
            'label'    => $label,
            'section'  => $section_id,
            'setting' => $name,
            'priority' => 1
        )));
    }

    // type checkbox
    public function customize_type_checkbox($wp_customize, $label, $section_id, $name,  $default, $callback = null)
    {
        $wp_customize->add_setting($name, array(
            "default" => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "checkbox",
                "active_callback" => $callback,
            )
        ));
    }

    // type Image
    public function customize_type_image($wp_customize, $label, $section_id, $name,  $default = '', $callback = null)
    {
        $wp_customize->add_setting($name, array(
            "default" => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Upload_Control($wp_customize, $name, array(
            'label'    => $label,
            'section'  => $section_id,
            'setting' => $name,
            'priority' => 20,
            "active_callback" => $callback,
        )));
    }

    public function customize_type_select($wp_customize, $label, $section_id, $name,  $default, $select_value,  $callback = null)
    {
        $wp_customize->add_setting($name, array(
            'default'     => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "select",
                'choices'     => $select_value,
                "active_callback" => $callback,
            )
        ));
    }

    public function customize_type_radio($wp_customize, $label, $section_id, $name,  $default, $radio_value, $callback = null)
    {
        $wp_customize->add_setting($name, array(
            'default'     => $default,
            "transport" => "refresh",

        ));

        $wp_customize->add_control(new \WP_Customize_Control(
            $wp_customize,
            $name,
            array(
                "label" => $label,
                "section" => $section_id,
                "settings" => $name,
                "type" => "radio",
                'choices'     => $radio_value,
                "active_callback" => $callback,
            )
        ));
    }
}
