<?php

namespace Layerdrops\Roofsie;

class Assets
{

    /**
     * Class constructor
     */
    function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'register_assets']);
        add_action('admin_enqueue_scripts', [$this, 'register_assets']);
    }

    /**
     * All available scripts
     *
     * @return array
     */
    public function get_scripts()
    {
        return [
            'bootstrap-select' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/bootstrap-select/js/bootstrap-select.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/bootstrap-select/js/bootstrap-select.min.js'),
                'deps'    => ['jquery', 'bootstrap']
            ],
            'jquery-bxslider' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/bxslider/jquery.bxslider.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/bxslider/jquery.bxslider.min.js'),
                'deps'    => ['jquery']
            ],
            'countdown' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/countdown/countdown.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/countdown/countdown.min.js'),
                'deps'    => ['jquery']
            ],
            'isotope' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/isotope/isotope.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/isotope/isotope.js'),
                'deps'    => ['jquery']
            ],
            'imagesloaded' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/imagesloaded/imagesloaded.pkgd.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/imagesloaded/imagesloaded.pkgd.min.js'),
                'deps'    => ['jquery']
            ],
            'jarallax' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/jarallax/jarallax.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/jarallax/jarallax.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-ajaxchimp' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/jquery-ajaxchimp/jquery.ajaxchimp.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-appear' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/jquery-appear/jquery.appear.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/jquery-appear/jquery.appear.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-easing' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/jquery-easing/jquery.easing.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/jquery-easing/jquery.easing.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-circle-progress' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/jquery-circle-progress/jquery.circle-progress.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/jquery-circle-progress/jquery.circle-progress.min.js'),
                'deps'    => ['jquery']
            ],
            'jquery-magnific-popup' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/jquery-magnific-popup/jquery.magnific-popup.min.js'),
                'deps'    => ['jquery']
            ],
            'odometer' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/odometer/odometer.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/odometer/odometer.min.js'),
                'deps'    => ['jquery']
            ],
            'owl-carousel' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/owl-carousel/owl.carousel.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/owl-carousel/owl.carousel.min.js'),
                'deps'    => ['jquery']
            ],
            'swiper' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/swiper/swiper.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/swiper/swiper.min.js'),
                'deps'    => ['jquery']
            ],
            'wow' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/wow/wow.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/wow/wow.js'),
                'deps'    => ['jquery']
            ],

            'sharer' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/sharer/sharer.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/sharer/sharer.min.js'),
                'deps'    => ['jquery']
            ],
            'timepicker' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/timepicker/timePicker.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/timepicker/timePicker.js'),
                'deps'    => ['jquery']
            ],
            'jquery-validate' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/jquery-validate/jquery.validate.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/jquery-validate/jquery.validate.min.js'),
                'deps'    => ['jquery']
            ],
            'select2' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/select2/js/select2.min.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/select2/js/select2.min.js'),
                'deps'    => ['jquery']
            ],

            'roofsie-addon-customizer' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/js/roofsie-addon-customizer.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/js/roofsie-addon-customizer.js'),
                'deps'    => ['jquery', 'select2']
            ],

            'roofsie-addon-script' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/js/roofsie-addon.js',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/js/roofsie-addon.js'),
                'deps'    => ['jquery']
            ]
        ];
    }

    /**
     * All available styles
     *
     * @return array
     */
    public function get_styles()
    {
        return [
            'animate' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/animate/animate.min.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/animate/animate.min.css')
            ],
            'custom-animate' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/animate/custom-animate.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/animate/custom-animate.css')
            ],
            'bootstrap-select' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/bootstrap-select/css/bootstrap-select.min.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/bootstrap-select/css/bootstrap-select.min.css')
            ],
            'bxslider' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/bxslider/jquery.bxslider.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/bxslider/jquery.bxslider.css')
            ],
            'jarallax' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/jarallax/jarallax.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/jarallax/jarallax.css')
            ],
            'jquery-magnific-popup' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/jquery-magnific-popup/jquery.magnific-popup.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/jquery-magnific-popup/jquery.magnific-popup.css')
            ],
            'odometer' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/odometer/odometer.min.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/odometer/odometer.min.css')
            ],
            'owl-carousel' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/owl-carousel/owl.carousel.min.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/owl-carousel/owl.carousel.min.css')
            ],
            'owl-theme' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/owl-carousel/owl.theme.default.min.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/owl-carousel/owl.theme.default.min.css')
            ],
            'reey-font' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/reey-font/stylesheet.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/reey-font/stylesheet.css')
            ],
            'swiper' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/swiper/swiper.min.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/swiper/swiper.min.css')
            ],
            'timepicker' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/timepicker/timePicker.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/timepicker/timePicker.css')
            ],
            'roofsi-jquery-ui' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/jquery-ui/jquery-ui.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/jquery-ui/jquery-ui.css')
            ],
            'select2' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/vendors/select2/css/select2.min.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/vendors/select2/css/select2.min.css')
            ],
            'roofsie-addon-style' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/css/roofsie-addon.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/css/roofsie-addon.css')
            ],
            'roofsie-addon-admin-style' => [
                'src'     => ROOFSIE_ADDON_ASSETS . '/css/roofsie-addon-admin.css',
                'version' => filemtime(ROOFSIE_ADDON_PATH . '/assets/css/roofsie-addon-admin.css')
            ]
        ];
    }

    /**
     * Register scripts and styles
     *
     * @return void
     */
    public function register_assets()
    {
        $scripts = $this->get_scripts();
        $styles  = $this->get_styles();

        foreach ($scripts as $handle => $script) {
            $deps = isset($script['deps']) ? $script['deps'] : false;

            wp_register_script($handle, $script['src'], $deps, $script['version'], true);
        }

        foreach ($styles as $handle => $style) {
            $deps = isset($style['deps']) ? $style['deps'] : false;

            wp_register_style($handle, $style['src'], $deps, $style['version']);
        }
    }
}
