<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!--Process Start-->
    <section class="process">
        <?php if (!empty($settings['bg_image']['url'])) : ?>
            <div class="process-bg" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);"></div>
        <?php endif; ?>
        <div class="container">
            <div class="row">
                <?php if (is_array($settings['work_process_items'])) : ?>
                    <?php foreach ($settings['work_process_items'] as $item) : ?>
                        <!--Process Single Start-->
                        <div class="col-xl-4 col-lg-4">
                            <div class="process__single">
                                <div class="process__content-box">
                                    <div class="process__icon-box">
                                        <div class="process__icon icon-svg-large">
                                            <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
                                            <?php if (!empty($item['shape']['url'])) : ?>
                                                <div class="process__shape" style="background-image: url(<?php echo esc_url($item['shape']['url']); ?>)"></div>
                                            <?php endif; ?>
                                            <div class="process__count"></div>
                                        </div>
                                    </div>
                                    <div class="process__details">
                                        <h3 class="process__title"><?php echo wp_kses($item['title'], 'roofsie_allowed_tags'); ?></h3>
                                        <p class="process__text"><?php echo wp_kses($item['content'], 'roofsie_allowed_tags'); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--Process Single End-->
                <?php endforeach;
                endif; ?>
            </div>
        </div>
    </section>
    <!--Process End-->
<?php endif; ?>