<?php if ('layout_one' === $settings['layout_type']) :

?>
	<!--Trust Company Start-->
	<section class="trust-company">
		<?php if (!empty($settings['bg_image']['url'])) : ?>
			<div class="trust-company-shape-1">
				<img src="<?php echo esc_url($settings['bg_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['bg_image']['id'])); ?>">
			</div>
		<?php endif; ?>
		<div class="trust-company-shape-2"></div>
		<div class="trust-company-shape-3"></div>
		<div class="trust-company-shape-4"></div>
		<?php if (!empty($settings['shape']['url'])) : ?>
			<div class="trust-company-bg jarallax" data-jarallax data-speed="0.2" data-imgPosition="50% 0%" style="background-image: url(<?php echo esc_url($settings['shape']['url']); ?>);"></div>
		<?php endif; ?>
		<div class="container">
			<div class="row">
				<div class="col-xl-6 col-lg-7">
					<div class="trust-company__left">
						<div class="trust-company__video-link">
							<a href="<?php echo esc_url($settings['video_url']); ?>" class="video-popup">
								<div class="trust-company__video-icon">
									<span class="fa fa-play"></span>
									<i class="ripple"></i>
								</div>
							</a>
						</div>
						<?php if (!empty($settings['sec_title'])) : ?>
							<h2 class="trust-company__title"><?php echo wp_kses($settings['sec_title'], 'roofsie_allowed_tags'); ?></h2>
						<?php endif; ?>
					</div>
				</div>
				<div class="col-xl-6 col-lg-5">
					<div class="trust-company__right">
						<?php if (is_array($settings['checklist'])) : ?>
							<ul class="list-unstyled trust-compay__points ml-0">
								<?php foreach ($settings['checklist'] as $item) : ?>
									<li>
										<div class="icon icon-svg">
											<?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
										</div>
										<div class="text">
											<p><?php echo esc_html($item['title']); ?></p>
										</div>
									</li>
								<?php endforeach ?>
							</ul>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--Trust Company End-->

<?php endif; ?>