<?php if ('layout_two' == $settings['layout_type']) : ?>
	<!--Testimonial Two Start-->
	<section class="testimonial-two">
		<?php if (!empty($settings['bg_image']['url'])) : ?>
			<div class="testimonial-two-shape" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);"></div>
		<?php endif; ?>
		<div class="container">
			<div class="row">
				<?php if (!empty($settings['sec_title']) || !empty($settings['sec_sub_title'])) : ?>
					<div class="col-xl-4 col-lg-4">
						<div class="testimonial-two__left">
							<div class="section-title text-left">
								<?php if (!empty($settings['sec_sub_title'])) : ?>
									<div class="section-sub-title-box">
										<p class="section-sub-title"><?php echo wp_kses($settings['sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
										<?php if (!empty($settings['sec_sub_image']['url'])) : ?>
											<div class="section-title-shape-1">
												<img src="<?php echo esc_url($settings['sec_sub_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['sec_sub_image']['id'])); ?>">
											</div>
										<?php endif; ?>
									</div>
								<?php endif; ?>
								<?php if (!empty($settings['sec_title'])) : ?>
									<h2 class="section-title__title"><?php echo wp_kses($settings['sec_title'], 'roofsie_allowed_tags'); ?></h2>
								<?php endif; ?>
							</div>
						</div>
					</div>
				<?php endif; ?>
				<div class="col-xl-8 col-lg-8">
					<div class="testimonial-two__right">
						<div class="testimonial-two__carousel owl-carousel owl-theme thm-owl__carousel" data-owl-options='{
                                "loop": true,
                                "autoplay": true,
                                "margin": 50,
                                "nav": false,
                                "dots": true,
                                "smartSpeed": 500,
                                "autoplayTimeout": 10000,
                                "navText": ["<span class=\"fa fa-angle-left\"></span>","<span class=\"fa fa-angle-right\"></span>"],
                                "responsive": {
                                    "0": {
                                        "items": 1
                                    },
                                    "768": {
                                        "items": 1
                                    },
                                    "992": {
                                        "items": 1
                                    },
                                    "1200": {
                                        "items": 1.4884785
                                    }
                                }
                            }'>
							<?php if (is_array($settings['testimonials'])) : ?>
								<?php foreach ($settings['testimonials'] as $item) : ?>
									<!--Testimonial One Single Start-->
									<div class="item">
										<div class="testimonial-one__single">
											<div class="testimonial-one__client-info">
												<?php if (!empty($item['image']['url'])) : ?>
													<div class="testimonial-one__client-img-box">
														<div class="testimonial-one__client-img">
															<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['image']['url'])); ?>">
														</div>
													</div>
												<?php endif; ?>
												<div class="testimonial-one__client-details">
													<h4 class="testimonial-one__client-name"><?php echo esc_html($item['name']); ?></h4>
													<p class="testimonial-one__client-sub-title"><?php echo esc_html($item['designation']); ?></p>
												</div>
											</div>
											<p class="testimonial-one__text"><?php echo wp_kses($item['testimonial'], 'roofsie_allowed_tags'); ?></p>
											<div class="testimonial-one__rating">
												<?php for ($x = 1; $x <= $item['rating']['size']; $x++) :  ?>
													<i class="fa fa-star"></i>
												<?php endfor; ?>
											</div>
										</div>
									</div>
									<!--Testimonial One Single End-->
								<?php endforeach; ?>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--Testimonial Two End-->
<?php endif; ?>