<?php if ('layout_one' == $settings['layout_type']) : ?>

	<!--Testimonial One Start-->
	<section class="testimonial-one">
		<?php if (!empty($settings['bg_image']['url'])) : ?>
			<div class="testimonial-one-shape" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>);"></div>
		<?php endif; ?>
		<div class="container">
			<?php if (!empty($settings['sec_title']) || !empty($settings['sec_sub_title'])) : ?>
				<div class="section-title text-center">
					<div class="section-sub-title-box">
						<?php if (!empty($settings['sec_sub_title'])) : ?>
							<p class="section-sub-title"><?php echo wp_kses($settings['sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
						<?php endif; ?>
						<?php if (!empty($settings['sec_sub_image']['url'])) : ?>
							<div class="section-title-shape-1">
								<img src="<?php echo esc_url($settings['sec_sub_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['sec_sub_image']['id'])); ?>">
							</div>
						<?php endif; ?>
					</div>
					<?php if (!empty($settings['sec_title'])) : ?>
						<h2 class="section-title__title"><?php echo wp_kses($settings['sec_title'], 'roofsie_allowed_tags'); ?></h2>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="testimonial-one__carousel owl-carousel owl-theme thm-owl__carousel" data-owl-options='<?php echo esc_attr(roofsie_get_owl_options($settings)); ?>'>
				<?php if (is_array($settings['testimonials'])) : ?>
					<?php foreach ($settings['testimonials'] as $item) : ?>
						<!--Testimonial One Single Start-->
						<div class="item">
							<div class="testimonial-one__single">
								<div class="testimonial-one__client-info">
									<?php if (!empty($item['image']['url'])) : ?>
										<div class="testimonial-one__client-img-box">
											<div class="testimonial-one__client-img">
												<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['image']['id'])); ?>">
											</div>
										</div>
									<?php endif; ?>
									<div class="testimonial-one__client-details">
										<h4 class="testimonial-one__client-name"><?php echo esc_html($item['name']); ?></h4>
										<p class="testimonial-one__client-sub-title"><?php echo esc_html($item['designation']); ?></p>
									</div>
								</div>
								<p class="testimonial-one__text"><?php echo wp_kses($item['testimonial'], 'roofsie_allowed_tags'); ?></p>
								<div class="testimonial-one__rating">
									<?php for ($x = 1; $x <= $item['rating']['size']; $x++) :  ?>
										<i class="fa fa-star"></i>
									<?php endfor; ?>
								</div>
							</div>
						</div>
						<!--Testimonial One Single End-->
					<?php endforeach; ?>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<!--Testimonial One End-->

<?php endif; ?>