<?php if ('layout_four' == $settings['layout_type']) : ?>
	<!--Testimonials Page Start-->
	<section class="testimonials-carousel-page">
		<div class="container">
			<div class="testimonials-carousel thm-owl__carousel owl-theme owl-carousel carousel-dot-style" data-owl-options='<?php echo esc_attr(roofsie_get_owl_options($settings)); ?>'>
				<?php if (is_array($settings['testimonials'])) : ?>
					<?php foreach ($settings['testimonials'] as $item) : ?>
						<!--Testimonial One Single Start-->
						<div class="item">
							<div class="testimonial-one__single">
								<div class="testimonial-one__client-info">
									<?php if (!empty($item['image']['url'])) : ?>
										<div class="testimonial-one__client-img-box">
											<div class="testimonial-one__client-img">
												<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['image']['id'])); ?>">
											</div>
										</div>
									<?php endif; ?>
									<div class="testimonial-one__client-details">
										<h4 class="testimonial-one__client-name"><?php echo esc_html($item['name']); ?></h4>
										<p class="testimonial-one__client-sub-title"><?php echo esc_html($item['designation']); ?></p>
									</div>
								</div>
								<p class="testimonial-one__text"><?php echo wp_kses($item['testimonial'], 'roofsie_allowed_tags'); ?></p>
								<div class="testimonial-one__rating">
									<?php for ($x = 1; $x <= $item['rating']['size']; $x++) :  ?>
										<i class="fa fa-star"></i>
									<?php endfor; ?>
								</div>
							</div>
						</div>
						<!--Testimonial One Single End-->
					<?php endforeach; ?>
				<?php endif; ?>
			</div>
		</div>
	</section>
	<!--Testimonials Page End-->
<?php endif; ?>