<?php if ('layout_three' == $settings['layout_type']) : ?>
	<!--Team Page Start-->
	<section class="team-carousel-page">
		<div class="container">
			<div class="team-carousel thm-owl__carousel owl-theme owl-carousel carousel-dot-style" data-owl-options='<?php echo esc_attr(roofsie_get_owl_options($settings)); ?>'>
				<?php if (is_array($settings['layout_two_team_items'])) : ?>
					<?php
					foreach ($settings['layout_two_team_items'] as $item) : ?>
						<!--Team One Single Start-->
						<div class="item">
							<div class="team-one__single">
								<div class="team-one__img-box">
									<div class="team-one__img">
										<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_url(roofsie_get_thumbnail_alt($item['image']['id'])); ?>">
									</div>
									<ul class="list-unstyled team-one__social">
										<?php echo wp_kses($item['social_network'], 'roofsie_allowed_tags'); ?>
									</ul>
								</div>
								<div class="team-one__content-box">
									<div class="team-one__content">
										<h3 class="team-one__name">
											<?php if (!empty($item['url']['url'])) : ?>
												<a href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['name']); ?></a>
											<?php else : ?>
												<?php echo esc_html($item['name']); ?>
											<?php endif; ?>
										</h3>
										<p class="team-one__sub-title"><?php echo esc_html($item['designation']); ?></p>
										<ul class="list-unstyled team-one__social-two">
											<li><a href="#"><i class="fas fa-share-alt"></i></a></li>
										</ul>
										<div class="team-one__shape">
											<?php if (!empty($item['shape']['url'])) : ?>
												<div class="team-one__shape">
													<img src="<?php echo esc_url($item['shape']['url']); ?>" alt="<?php echo esc_url(roofsie_get_thumbnail_alt($item['shape']['id'])); ?>">
												</div>
											<?php endif; ?>
										</div>
									</div>
								</div>
							</div>
						</div>
						<!--Team One Single End-->
				<?php
					endforeach;
				endif; ?>
			</div>
		</div>
	</section>
	<!--Team Page End-->
<?php endif; ?>