<?php if ('layout_four' == $settings['layout_type']) : ?>

	<!--Team Details Start-->
	<section class="team-details">
		<div class="container">
			<div class="row">
				<div class="col-xl-6 col-lg-6">
					<div class="team-details__left">
						<div class="team-details__img">
							<?php if (!empty($settings['layout_four_image']['url'])) : ?>
								<img src="<?php echo esc_url($settings['layout_four_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_four_image']['id'])); ?>">
							<?php endif; ?>
							<?php if (!empty($settings['big_text'])) : ?>
								<div class="team-details__big-text"><?php echo esc_html($settings['big_text']); ?></div>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<div class="col-xl-6 col-lg-6">
					<div class="team-details__right">
						<div class="team-details__content">
							<?php if (!empty($settings['layout_four_name']) || !empty($settings['layout_four_designation'])) : ?>
								<div class="section-title text-left">
									<?php if (!empty($settings['layout_four_designation'])) : ?>
										<div class="section-sub-title-box">
											<p class="section-sub-title"><?php echo wp_kses($settings['layout_four_designation'], 'roofsie_allowed_tags'); ?></p>
											<?php if (!empty($settings['layout_two_designation_image']['url'])) : ?>
												<div class="section-title-shape-1">
													<img src="<?php echo esc_url($settings['layout_two_designation_image']['url']) ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['layout_two_designation_image']['id'])); ?>">
												</div>
											<?php endif; ?>
										</div>
									<?php endif; ?>
									<?php if (!empty($settings['layout_four_name'])) : ?>
										<h2 class="section-title__title"><?php echo esc_html($settings['layout_four_name']); ?></h2>
									<?php endif; ?>
								</div>
							<?php endif; ?>
							<div class="team-details__social">
								<?php if (is_array($settings['social_icons'])) : ?>
									<?php foreach ($settings['social_icons'] as $item) : ?>
										<a <?php echo esc_attr(!empty($item['social_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['social_url']['url']); ?>">
											<?php \Elementor\Icons_Manager::render_icon($item['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
										</a>
									<?php endforeach; ?>
								<?php endif; ?>
							</div>
							<?php if (!empty($settings['layout_four_highlighted_text'])) : ?>
								<p class="team-details__text-1"><?php echo esc_html($settings['layout_four_highlighted_text']); ?></p>
							<?php endif; ?>
							<?php echo wp_kses($settings['layout_four_content'], 'roofsie_allowed_tags'); ?>
							<?php if (!empty($settings['button_label'])) : ?>
								<div class="team-details__btn-box">
									<a <?php echo esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>" class="thm-btn team-details__btn"> <i class="fa fa-arrow-right"></i> <?php echo esc_html($settings['button_label']); ?></a>
								</div>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--Team Details End-->

<?php endif; ?>