<?php if ('layout_five' == $settings['layout_type']) : ?>
	<!--Team One Start-->
	<section class="team-one team-two">
		<div class="container">
			<?php if (!empty($settings['sec_title']) || !empty($settings['sec_sub_title'])) : ?>
				<div class="section-title text-center">
					<?php if (!empty($settings['sec_sub_title'])) : ?>
						<div class="section-sub-title-box">
							<p class="section-sub-title"><?php echo wp_kses($settings['sec_sub_title'], 'roofsie_allowed_tags'); ?></p>
							<?php if (!empty($settings['sub_title_image']['url'])) : ?>
								<div class="section-title-shape-1">
									<img src="<?php echo esc_url($settings['sub_title_image']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['sub_title_image']['id'])); ?>">
								</div>
							<?php endif; ?>
						</div>
					<?php endif; ?>
					<?php if (!empty($settings['sec_title'])) : ?>
						<h2 class="section-title__title"><?php echo wp_kses($settings['sec_title'], 'roofsie_allowed_tags'); ?></h2>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="row">
				<?php if (is_array($settings['team_items'])) : ?>
					<?php $i = 1;
					foreach ($settings['team_items'] as $item) : ?>
						<!--Team One Single Start-->
						<div class="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="<?php echo esc_attr($i); ?>00ms">
							<div class="team-one__single">
								<div class="team-one__img-box">
									<div class="team-one__img">
										<img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php echo esc_url(roofsie_get_thumbnail_alt($item['image']['id'])); ?>">
									</div>
									<ul class="list-unstyled team-one__social">
										<?php echo wp_kses($item['social_network'], 'roofsie_allowed_tags'); ?>
									</ul>
								</div>
								<div class="team-one__content-box">
									<div class="team-one__content">
										<h3 class="team-one__name">
											<?php if (!empty($item['url']['url'])) : ?>
												<a href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['name']); ?></a>
											<?php else : ?>
												<?php echo esc_html($item['name']); ?>
											<?php endif; ?>
										</h3>
										<p class="team-one__sub-title"><?php echo esc_html($item['designation']); ?></p>
										<ul class="list-unstyled team-one__social-two">
											<li><a href="#"><i class="fas fa-share-alt"></i></a></li>
										</ul>
										<?php if (!empty($item['shape']['url'])) : ?>
											<div class="team-one__shape">
												<img src="<?php echo esc_url($item['shape']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($item['shape']['id'])); ?>">
											</div>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
						<!--Team One Single End-->
				<?php $i++;
					endforeach;
				endif; ?>
			</div>
		</div>
	</section>
	<!--Team One End-->
<?php endif; ?>