<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!--Brand One Start-->
    <section class="brand-one">
        <div class="brand-one__inner">
            <?php if (!empty($settings['shape1']['url'])) : ?>
                <div class="brand-one__shape-1 float-bob-y">
                    <img src="<?php echo esc_url($settings['shape1']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['shape1']['id'])); ?>">
                </div>
            <?php endif; ?>
            <?php if (!empty($settings['shape2']['url'])) : ?>
                <div class="brand-one__shape-2 float-bob-y">
                    <img src="<?php echo esc_url($settings['shape2']['url']); ?>" alt="<?php echo esc_attr(roofsie_get_thumbnail_alt($settings['shape2']['id'])); ?>">
                </div>
            <?php endif; ?>
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="brand-one__carousel thm-owl__carousel owl-theme owl-carousel" data-owl-options='<?php echo esc_attr(roofsie_get_owl_options($settings)); ?>'>
                            <?php foreach ($settings['sponsor_images'] as $item) :  ?>
                                <!--Brand One Single-->
                                <div class="brand-one__single">
                                    <div class="brand-one__img">
                                        <?php if (!empty($item['link'])) : ?>
                                            <a href="<?php echo esc_url($item['link']); ?>">
                                                <?php echo wp_get_attachment_image($item['image']['id'], 'roofsie_brand_logo_115X90'); ?>
                                            </a>
                                        <?php else : ?>
                                            <?php echo wp_get_attachment_image($item['image']['id'], 'roofsie_brand_logo_115X90'); ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <!--Brand One Single-->
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--Brand One End-->
<?php endif; ?>