<?php if ('layout_one' == $settings['layout_type']) : ?>
    <div class="work-details__content-right">
        <div class="work-details__details-box">
            <ul class="list-unstyled work-details__details-list ml-0">
                <?php if (is_array($settings['portfolio_info'])) : ?>
                    <?php foreach ($settings['portfolio_info'] as $item) : ?>
                        <li>
                            <p class="work-details__client"><?php echo esc_html($item['title']); ?></p>
                            <h4 class="work-details__name"><?php echo esc_html($item['content']); ?></h4>
                        </li>
                    <?php endforeach; ?>
                <?php endif; ?>
                <?php if (is_array($settings['social_icons'])) : ?>
                    <li>
                        <div class="work-details__social">
                            <?php foreach ($settings['social_icons'] as $item) : ?>
                                <a href="<?php echo esc_url($item['social_url']['url']);  ?>" <?php echo esc_attr(!empty($item['social_url']['is_external']) ? 'target=_blank' : ' '); ?>>
                                    <?php \Elementor\Icons_Manager::render_icon($item['social_icon'], ['aria-hidden' => 'true', 'class' => ' '], 'i'); ?>
                                </a>
                            <?php endforeach; ?>
                        </div>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
<?php endif; ?>