<?php if ('layout_one' == $settings['layout_type']) : ?>
    <div class="service-details__need-help">
        <?php if (!empty($settings['background_image']['url'])) : ?>
            <div class="service-details__need-help-bg" style="background-image: url(<?php echo esc_url($settings['background_image']['url']); ?>)"></div>
        <?php endif; ?>
        <div class="service-details__need-help-icon icon-svg-large">
            <?php \Elementor\Icons_Manager::render_icon($settings['icon'], ['aria-hidden' => 'true', 'class' => ' '], 'span'); ?>
        </div>
        <?php if (!empty($settings['title'])) : ?>
            <h2 class="service-details__need-help-title"><?php echo wp_kses($settings['title'], 'roofsie_allowed_tags'); ?></h2>
        <?php endif; ?>
        <?php if (!empty($settings['call_text']) || !empty($settings['call_number'])) : ?>
            <div class="service-details__need-help-contact">
                <p><?php echo esc_html($settings['call_text']); ?></p>
                <a href="<?php echo esc_url($settings['call_url']); ?>"><?php echo esc_html($settings['call_number']); ?></a>
            </div>
        <?php endif; ?>
    </div>

<?php endif; ?>